<?php

namespace Drupal\at_ls\Http;

/**
 * Http Client interface.
 */
interface HttpClientInterface {

  /**
   * Makes request to the API.
   *
   * @param string $method
   *   The request method.
   * @param string $uri
   *   The request URI.
   * @param array $options
   *   The request options.
   *
   * @return string|null
   *   The response from API.
   *
   * @throws \Exception
   */
  public function handleRequest(string $method, string $uri, array $options = []): ?string;

}
