<?php

namespace Drupal\at_ls;

use Drupal\entity\EntityViewsData;

/**
 * Provides views data for the AT-LS translation request entity type.
 */
class AtlsTranslationRequestViewsData extends EntityViewsData {

  /**
   * {@inheritdoc}
   */
  public function getViewsData() {
    $data = parent::getViewsData();

    // Sets right plugin id to options select filters.
    $data['at_ls_translation_request']['status']['filter']['id'] = 'state_machine_state';
    $data['at_ls_translation_request']['source_language']['filter']['id'] = 'list_field';
    $data['at_ls_translation_request']['target_language']['filter']['id'] = 'list_field';

    return $data;
  }

}
