<?php

namespace Drupal\at_ls\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\Core\Entity\TranslatableInterface;

/**
 * Defines the AT-LS translation request event.
 */
class AtlsTranslatableEntityEvent extends Event {

  const INSERT = 'at_ls_translatable_entity_insert';
  const UPDATE = 'at_ls_translatable_entity_update';

  /**
   * The AT-LS translation request entity.
   *
   * @var \Drupal\Core\Entity\TranslatableInterface
   */
  public TranslatableInterface $entity;

  /**
   * Constructs the object.
   *
   * @param \Drupal\Core\Entity\TranslatableInterface $entity
   *   The entity object.
   */
  public function __construct(TranslatableInterface $entity) {
    $this->entity = $entity;
  }

  /**
   * Gets the translatable entity.
   *
   * @return \Drupal\Core\Entity\TranslatableInterface
   *   The entity object.
   */
  public function getEntity() {
    return $this->entity;
  }

}
