<?php

namespace Drupal\at_ls\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for the at-ls translation request entity edit forms.
 */
final class AtlsTranslationRequestForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $form = parent::form($form, $form_state);

    // Disables some fields.
    $disabled_fields = [
      'uid',
      'created',
      'changed',
      'origin_url',
      'entity_type',
      'entity_id',
      'source_language',
      'target_language',
      'translation_type',
      'content',
    ];

    foreach ($disabled_fields as $field_name) {
      $form[$field_name]['#disabled'] = TRUE;
    }

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state): int {
    $result = parent::save($form, $form_state);
    $entity_url = $this->entity->toUrl()->setAbsolute()->toString();
    $this->messenger()->addMessage($this->t('Saved AT-LS translation request: <a href=":url">%label</a>', [
      ':url' => $entity_url,
      '%label' => $this->entity->id(),
    ]));
    $form_state->setRedirectUrl($this->entity->toUrl());

    return $result;
  }

}
