<?php

namespace Drupal\at_ls\Guard;

use Drupal\at_ls\Service\AtlsTranslationRequestManagerInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\state_machine\Guard\GuardInterface;
use Drupal\state_machine\Plugin\Workflow\WorkflowInterface;
use Drupal\state_machine\Plugin\Workflow\WorkflowTransition;

/**
 * Defines the interface for guards.
 */
class ProcessGuard implements GuardInterface {

  /**
   * The ProcessGuard constructor.
   *
   * @param \Drupal\at_ls\Service\AtlsTranslationRequestManagerInterface $translationRequestManager
   *   The AT-LS translation request manager.
   */
  public function __construct(
    protected AtlsTranslationRequestManagerInterface $translationRequestManager
  ) {}

  /**
   * {@inheritdoc}
   */
  public function allowed(WorkflowTransition $transition, WorkflowInterface $workflow, EntityInterface $entity) {
    /** @var \Drupal\at_ls\Entity\AtlsTranslationRequestInterface $entity */
    if ($transition->getId() == 'to_processed' && $entity->isProcessable()) {
      if ($this->translationRequestManager->hasStringsReady($entity)) {
        return TRUE;
      }

      // Runs process and checks if strings are ready.
      $this->translationRequestManager->process($entity);
      if ($this->translationRequestManager->hasStringsReady($entity)) {
        return TRUE;
      }
      else {
        return FALSE;
      }
    }

    return TRUE;
  }

}
