<?php

namespace Drupal\at_ls\Service;

use Drupal\at_ls\Entity\AtlsTranslationRequestInterface;

/**
 * Provides an interface defining the AT-LS translation request manager service.
 */
interface AtlsTranslationRequestManagerInterface {

  /**
   * Builds the content of the AT-LS translation request to translate.
   *
   * @param string $entity_type
   *   The entity type.
   * @param string $entity_id
   *   The entity id.
   * @param string $source_language
   *   The source language.
   *
   * @return array
   *   An array with the content to translate.
   */
  public function buildContent(string $entity_type, string $entity_id, string $source_language): array;

  /**
   * Gets AT-LS translation request strings.
   *
   * @param \Drupal\at_ls\Entity\AtlsTranslationRequestInterface $translation_request
   *   The AT-LS translation request.
   *
   * @return array
   *   An array with the AT-LS translation request strings.
   */
  public function getStrings(AtlsTranslationRequestInterface $translation_request): array;

  /**
   * Checks all AT-LS translation request strings are ready.
   *
   * @param \Drupal\at_ls\Entity\AtlsTranslationRequestInterface $translation_request
   *   The AT-LS translation request.
   *
   * @return bool
   *   TRUE if has all strings delivered state, otherwise FALSE.
   */
  public function hasStringsReady(AtlsTranslationRequestInterface $translation_request): bool;

  /**
   * Process the AT-LS translation request.
   *
   * @param \Drupal\at_ls\Entity\AtlsTranslationRequestInterface $translation_request
   *   The AT-LS translation request.
   */
  public function process(AtlsTranslationRequestInterface $translation_request): void;

}
