<?php

namespace Drupal\at_ls\Access;

use Drupal\at_ls\Entity\AtlsTranslationRequestInterface;
use Drupal\Core\Access\AccessResult;
use Drupal\Core\Routing\Access\AccessInterface;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Checks AT-LS Translation Request access.
 */
class AtlsTranslationRequestAccessCheck implements AccessInterface {

  /**
   * Checks process an AT-LS Translation Request.
   *
   * @param \Drupal\Core\Routing\RouteMatchInterface $route_match
   *   The route match.
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The currently logged in account.
   */
  public function checkProcess(RouteMatchInterface $route_match, AccountInterface $account) {
    $translation_request = $route_match->getParameter('at_ls_translation_request');
    if (!$translation_request instanceof AtlsTranslationRequestInterface) {
      return AccessResult::neutral();
    }
    if (!$translation_request->isProcessable()) {
      return AccessResult::forbidden()->addCacheableDependency($translation_request);
    }

    return AccessResult::allowedIfHasPermission($account, 'administer at_ls_translation_request');
  }

}
