<?php

namespace Drupal\at_ls\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface defining an AT-LS string entity type.
 */
interface AtlsStringInterface extends ContentEntityInterface, EntityOwnerInterface, EntityChangedInterface {

  /**
   * The workflow state mapping with AT-LS status code.
   *
   * @var array
   */
  const ATLS_STATUS_WORKFLOW_STATE = [
    '10' => 'review',
    '20' => 'pending',
    '30' => 'delivered',
    '40' => 'removed',
    '100' => 'error',
  ];

  /**
   * Asynchronous translation type.
   *
   * @var string
   */
  const ASYNC = 'async';

  /**
   * Synchronous translation type.
   *
   * @var string
   */
  const SYNC = 'sync';

  /**
   * The status workflow ID.
   *
   * @var string
   */
  const WORKFLOW_ID = 'string_default';

  /**
   * The init status state.
   *
   * @var string
   */
  const INIT_WORKFLOW_STATE = 'review';

  /**
   * The delivered status state.
   *
   * @var string
   */
  const READY_WORKFLOW_STATE = 'delivered';

  /**
   * Gets the url callback for asynchronous translation.
   *
   * @return string
   *   The string of the absolute url.
   */
  public function getUrlCallback(): string;

  /**
   * Gets allowed languages.
   *
   * @return array
   *   An array of language codes.
   */
  public static function getAllowedLanguages(): array;

  /**
   * Gets allowed translation types.
   *
   * @return array
   *   An array of translation types.
   */
  public static function getAllowedTypes(): array;

  /**
   * Calculates the hash value.
   *
   * @param string $source_language
   *   The source language.
   * @param string $target_language
   *   The target language.
   * @param string $source_text
   *   The source text.
   *
   * @return string
   *   The hash value.
   */
  public static function getHash(string $source_language, string $target_language, string $source_text): string;

  /**
   * Checks if the entity is ready.
   *
   * @return bool
   *   TRUE if has the ready state and a target text, otherwise FALSE.
   */
  public function isReady(): bool;

}
