<?php

namespace Drupal\at_ls;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;

/**
 * Provides a list controller for the AT-LS translation request entity type.
 */
final class AtlsTranslationRequestListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header['id'] = $this->t('ID');
    $header['created'] = $this->t('Created');
    $header['changed'] = $this->t('Updated');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    /** @var \Drupal\at_ls\Entity\AtlsTranslationRequestInterface $entity */
    $row['id'] = $entity->toLink();
    $row['created']['data'] = $entity->get('created')->view(['label' => 'hidden']);
    $row['changed']['data'] = $entity->get('changed')->view(['label' => 'hidden']);
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  protected function getDefaultOperations(EntityInterface $entity) {
    $operations = parent::getDefaultOperations($entity);

    /** @var \Drupal\at_ls\Entity\AtlsTranslationRequestInterface $entity */
    if ($entity->access('view')) {
      $operations['view'] = [
        'title' => $this->t('View'),
        'weight' => 5,
        'url' => $entity->toUrl('canonical'),
      ];
    }
    if ($entity->isProcessable()) {
      $operations['process'] = [
        'title' => $this->t('Process'),
        'weight' => 5,
        'url' => $entity->toUrl('process-form'),
      ];
    }

    return $operations;
  }

}
