<?php

namespace Drupal\at_ls\Routing;

use Drupal\content_translation\ContentTranslationManagerInterface;
use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\Core\Routing\RoutingEvents;
use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouteCollection;

/**
 * Listens to the dynamic route events.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * Constructs a new RouteSubscriber object.
   *
   * @param \Drupal\content_translation\ContentTranslationManagerInterface $contentTranslationManager
   *   The content translation manager.
   */
  public function __construct(
    protected ContentTranslationManagerInterface $contentTranslationManager
  ) {}

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    foreach ($this->contentTranslationManager->getSupportedEntityTypes() as $entity_type_id => $entity_type) {
      // If the entity didn't get a at_ls_translate link template added by
      // hook_entity_types_alter(), skip it.
      if (!($path = $entity_type->getLinkTemplate('at_ls_translate'))) {
        continue;
      }

      $route = new Route($path);
      $route
        ->addDefaults([
          '_controller' => '\Drupal\at_ls\Controller\AtlsController::getCreateAtlsTranslationRequestForm',
          '_title' => 'Create AT-LS Translation Request',
        ])
        ->addRequirements([
          '_permission' => 'access create at-ls translation request form',
        ])
        ->setOption('_admin_route', TRUE)
        ->setOption('_entity_type_id', $entity_type_id);
      $collection->add("entity.$entity_type_id.at_ls_translate", $route);
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events = parent::getSubscribedEvents();
    $events[RoutingEvents::ALTER] = ['onAlterRoutes', 100];
    return $events;
  }

}
