<?php

/**
 * @file
 * Contains component file.
 */

/**
 * Implements hook_atomium_theme_hook().
 */
function atomium_atomium_theme_table() {
  return array(
    'table' => array(
      'template' => 'table',
      'variables' => array(
        'attributes' => array(),
        'caption' => NULL,
        'header' => array(),
        'colgroups' => array(),
        'rows' => array(),
        'footer' => array(),
        'sticky' => TRUE,
        'empty' => '',
      ),
    ),
  );
}

/**
 * Implements hook_atomium_definition_hook().
 */
function atomium_atomium_definition_table() {
  return array(
    'label' => 'Table',
    'description' => 'Table description.',
    'disable' => TRUE,
  );
}

/**
 * Implements hook_atomium_definition_form_hook().
 */
function atomium_atomium_definition_form_table(array $form, array &$form_state) {
  $form['element1'] = array(
    '#theme' => 'table',
    '#caption' => 'Default table.',
    '#colgroups' => array(
      array('data' => '', 'style' => 'background-color: #fafafa;'),
      '',
      '',
    ),
    '#header' => array(
      array('header cell 1.1', 'header cell 1.2', 'header cell 1.3'),
    ),
    '#rows' => array(
      array('body cell 1.1', 'body cell 1.2', 'body cell 1.3'),
      array('body cell 2.1', 'body cell 2.2', 'body cell 2.3'),
      array('body cell 3.1', 'body cell 3.2', 'body cell 3.3'),
    ),
    '#footer' => array(
      array('footer cell 1.1', 'footer cell 1.2', 'footer cell 1.3'),
    ),
    '#sticky' => FALSE,
  );

  $form['element2'] = array(
    '#theme' => 'table',
    '#caption' => 'Table with empty heading',
    '#colgroups' => array(
      array('data' => '', 'style' => 'background-color: #fafafa;'),
      '',
      '',
    ),
    '#header' => array(
      array('', 'header cell 1.2', 'header cell 1.3'),
    ),
    '#rows' => array(
      array('body cell 1.1', 'body cell 1.2', 'body cell 1.3'),
      array('body cell 2.1', 'body cell 2.2', 'body cell 2.3'),
      array('body cell 3.1', 'body cell 3.2', 'body cell 3.3'),
    ),
    '#footer' => array(
      array('footer cell 1.1', 'footer cell 1.2', 'footer cell 1.3'),
    ),
    '#sticky' => FALSE,
  );

  $form['element3'] = array(
    '#theme' => 'table',
    '#caption' => 'Table with colspan #1.',
    '#colgroups' => array(
      array('data' => '', 'style' => 'background-color: #fafafa;'),
      '',
      '',
    ),
    '#header' => array(
      array(
        array(
          'data' => 'header cell 1.1',
          'rowspan' => '2',
        ),
        array(
          'data' => 'header cell 1.2',
          'rowspan' => '2',
        ),
        array(
          'data' => 'header cell 1.3',
          'colspan' => '3',
        ),
      ),
      array('header cell 2.1', 'header cell 2.2', 'header cell 2.3'),
    ),
    '#rows' => array(
      array(
        'body cell 1.1', 'body cell 1.2', 'body cell 1.3', 'body cell 1.4',
        'body cell 1.5',
      ),
      array(
        'body cell 2.1', 'body cell 2.2', 'body cell 2.3', 'body cell 2.4',
        'body cell 2.5',
      ),
      array(
        'body cell 3.1', 'body cell 3.2', 'body cell 3.3', 'body cell 3.4',
        'body cell 3.5',
      ),
    ),
    '#footer' => array(
      array(
        'footer cell 1.1', 'footer cell 1.2', 'footer cell 1.3',
        'footer cell 1.4', 'footer cell 1.5',
      ),
    ),
    '#sticky' => FALSE,
  );

  $form['element4'] = array(
    '#theme' => 'table',
    '#caption' => 'Table with colspan #2.',
    '#colgroups' => array(
      array('data' => '', 'style' => 'background-color: #fafafa;'),
      '',
      '',
    ),
    '#header' => array(
      array(
        array(
          'data' => 'header cell 1.1',
          'colspan' => '2',
        ),
        array(
          'data' => 'header cell 1.2',
          'rowspan' => '2',
        ),
        array(
          'data' => 'header cell 1.3',
          'rowspan' => '2',
        ),
        array(
          'data' => 'header cell 1.4',
          'rowspan' => '2',
        ),
      ),
      array('header cell 2.1', 'header cell 2.2'),
    ),
    '#rows' => array(
      array(
        'body cell 1.1', 'body cell 1.2', 'body cell 1.3', 'body cell 1.4',
        'body cell 1.5',
      ),
      array(
        'body cell 2.1', 'body cell 2.2', 'body cell 2.3', 'body cell 2.4',
        'body cell 2.5',
      ),
      array(
        'body cell 3.1', 'body cell 3.2', 'body cell 3.3', 'body cell 3.4',
        'body cell 3.5',
      ),
    ),
    '#footer' => array(
      array(
        'footer cell 1.1', 'footer cell 1.2', 'footer cell 1.3',
        'footer cell 1.4', 'footer cell 1.5',
      ),
    ),
    '#sticky' => FALSE,
  );

  $form['element5'] = array(
    '#theme' => 'table',
    '#caption' => 'Table with colspan #3.',
    '#colgroups' => array(
      array('data' => '', 'style' => 'background-color: #fafafa;'),
      '',
      '',
    ),
    '#header' => array(
      array(
        array(
          'data' => 'header cell 1.1',
          'rowspan' => '2',
        ),
        array(
          'data' => 'header cell 1.2',
          'colspan' => '2',
        ),
        array(
          'data' => 'header cell 1.3',
          'rowspan' => '2',
        ),
        array(
          'data' => 'header cell 1.4',
          'rowspan' => '2',
        ),
      ),
      array('header cell 2.1', 'header cell 2.2'),
    ),
    '#rows' => array(
      array(
        'body cell 1.1', 'body cell 1.2', 'body cell 1.3', 'body cell 1.4',
        'body cell 1.5',
      ),
      array(
        'body cell 2.1', 'body cell 2.2', 'body cell 2.3', 'body cell 2.4',
        'body cell 2.5',
      ),
      array(
        'body cell 3.1', 'body cell 3.2', 'body cell 3.3', 'body cell 3.4',
        'body cell 3.5',
      ),
    ),
    '#footer' => array(
      array(
        'footer cell 1.1', 'footer cell 1.2', 'footer cell 1.3',
        'footer cell 1.4', 'footer cell 1.5',
      ),
    ),
    '#sticky' => FALSE,
  );

  $form['element6'] = array(
    '#theme' => 'table',
    '#caption' => 'Table with colspan and empty heading.',
    '#colgroups' => array(
      array('data' => '', 'style' => 'background-color: #fafafa;'),
      '',
      '',
    ),
    '#header' => array(
      array(
        array(
          'data' => '',
          'rowspan' => '2',
        ),
        array(
          'data' => 'header cell 1.1',
          'rowspan' => '2',
        ),
        array(
          'data' => 'header cell 1.2',
          'colspan' => '3',
        ),
      ),
      array('header cell 2.1', 'header cell 2.2', 'header cell 2.3'),
    ),
    '#rows' => array(
      array(
        'body cell 1.1', 'body cell 1.2', 'body cell 1.3', 'body cell 1.4',
        'body cell 1.5',
      ),
      array(
        'body cell 2.1', 'body cell 2.2', 'body cell 2.3', 'body cell 2.4',
        'body cell 2.5',
      ),
      array(
        'body cell 3.1', 'body cell 3.2', 'body cell 3.3', 'body cell 3.4',
        'body cell 3.5',
      ),
    ),
    '#footer' => array(
      array(
        'footer cell 1.1', 'footer cell 1.2', 'footer cell 1.3',
        'footer cell 1.4', 'footer cell 1.5',
      ),
    ),
    '#sticky' => FALSE,
  );

  $form['element7'] = array(
    '#theme' => 'table',
    '#caption' => 'Table with sticky enabled.',
    '#colgroups' => array(
      array('data' => '', 'style' => 'background-color: #fafafa;'),
      '',
      '',
    ),
    '#header' => array(
      array('header cell 1.1', 'header cell 1.2', 'header cell 1.3'),
      array('header cell 2.1', 'header cell 2.2', 'header cell 2.3'),
    ),
    '#rows' => array(
      array('body cell 1.1', 'body cell 1.2', 'body cell 1.3'),
      array('body cell 2.1', 'body cell 2.2', 'body cell 2.3'),
      array('body cell 3.1', 'body cell 3.2', 'body cell 3.3'),
    ),
    '#footer' => array(
      array('footer cell 1.1', 'footer cell 1.2', 'footer cell 1.3'),
      array('footer cell 2.1', 'footer cell 2.2', 'footer cell 2.3'),
    ),
  );

  return $form;
}

/**
 * Implements hook_preprocess_hook().
 *
 * @SuppressWarnings(PHPMD.CyclomaticComplexity)
 * @SuppressWarnings(PHPMD.NPathComplexity)
 */
function atomium_preprocess_table(array &$variables, $hook) {
  $header = $variables['header'];
  $rows = $variables['rows'];
  $sticky = $variables['sticky'];
  $empty = $variables['empty'];

  if (isset($variables['attributes'])) {
    $variables['atomium']['attributes']['wrapper']
      ->merge($variables['attributes']);
  }

  // Allows to have multiple lines in the header.
  foreach ($variables['header'] as $item) {
    if (!\is_array($item) || (\is_array($item) && isset($item['data']))) {
      $header = $variables['header'] = array($variables['header']);

      break;
    }
  }

  // Add sticky headers, if applicable.
  if ($sticky === TRUE && \is_array($header) && \count($header) !== 0) {
    drupal_add_js('misc/tableheader.js');
    // Add 'sticky-enabled' class to the table to identify it for JS.
    // This is needed to target tables constructed by this function.
    $variables['atomium']['attributes']['wrapper']
      ->append('class', 'sticky-enabled');
  }

  // Add the 'empty' row message if available.
  if (empty($rows) && !empty($empty)) {
    $header_count = 0;
    foreach ($header[0] as $header_cell) {
      if (\is_array($header_cell)) {
        $header_count += isset($header_cell['colspan']) ? $header_cell['colspan'] : 1;
      }
      else {
        $header_count++;
      }
    }
    $variables['rows'][] = array(
      array(
        'data' => $empty,
        'colspan' => $header_count,
        'class' => array('empty', 'message'),
      ),
    );
  }

  $ts = !empty($header) ? tablesort_init($header[0]) : array();

  // Format the table colgroups row.
  $variables['colgroups'] = _atomium_table_format_rows(
    'colgroup',
    array($variables['colgroups']),
    $header,
    $ts,
    FALSE,
    $variables
  );

  // Format the table header rows.
  $variables['header'] = _atomium_table_format_rows(
    'header',
    $variables['header'],
    $header,
    $ts,
    TRUE,
    $variables
  );

  // Format the table footer rows.
  $variables['rows'] = _atomium_table_format_rows(
    'body',
    $variables['rows'],
    $header,
    $ts,
    FALSE,
    $variables
  );

  // Format the table footer rows.
  $variables['footer'] = _atomium_table_format_rows(
    'footer',
    $variables['footer'],
    $header,
    $ts,
    FALSE,
    $variables
  );
}

/**
 * Helper function that format table rows.
 *
 * @param string $type
 *   Type.
 * @param array $rows
 *   Rows.
 * @param array $header
 *   Header.
 * @param array $ts
 *   Table sort.
 * @param bool $is_header
 *   Is header?
 * @param array $variables
 *   Variables.
 *
 * @return array
 *   A proper render array of rows.
 *
 * @SuppressWarnings(PHPMD.CyclomaticComplexity)
 * @SuppressWarnings(PHPMD.NPathComplexity)
 */
function _atomium_table_format_rows($type, array $rows, array $header, array $ts, $is_header = FALSE, array &$variables = array()) {
  $rows_array = array();

  if (isset($header[0])) {
    $header = $header[0];
  }

  if (empty($rows)) {
    return $rows_array;
  }

  $flip = array('even' => 'odd', 'odd' => 'even');
  $class = 'even';
  foreach ($rows as $rowid => $row) {
    // Check if we're dealing with a simple or complex row.
    if (isset($row['data'])) {
      $cells = $row['data'];
      $no_striping = isset($row['no_striping']) ? $row['no_striping'] : FALSE;

      // Set the attributes array and exclude 'data' and 'no_striping'.
      $attributes = $row;
      unset($attributes['data'], $attributes['no_striping']);
    }
    else {
      $cells = $row;
      $attributes = array();
      $no_striping = FALSE;
    }

    if (\count($cells) === 0) {
      continue;
    }

    // Add odd/even class.
    if (!$no_striping) {
      $class = $flip[$class];
      $attributes['class'][] = $class;
    }

    $variables['atomium']['attributes'][$type . '-row-' . $rowid]
      ->merge($attributes);

    // Build row.
    $i = 0;

    foreach ($cells as $cellid => $cell) {
      if ($is_header === TRUE) {
        $cell = tablesort_header($cell, $header, $ts);
      }
      else {
        $cellid = $i;
        $cell = tablesort_cell($cell, $header, $ts, $i++);
      }

      // @todo: Check this part of code.
      $attributes_array = array();
      if (\is_array($cell)) {
        $cell += array('data' => '');
        $attributes_array = \array_diff_key(
          $cell,
          array(
            'data' => 'data',
            'header' => 'header',
          )
        );
        $cell = $cell['data'];
      }

      $variables['atomium']['attributes'][$type . '-cell-' . $rowid . '-' . $cellid] = $attributes_array;
      $rows_array['row-' . $rowid]['cells']['cell-' . $cellid] = $cell;
    }
  }

  return $rows_array;
}
