<?php

/**
 * @file
 * Contains component file.
 */

/**
 * Implements hook_preprocess_hook().
 *
 * @SuppressWarnings(PHPMD.CyclomaticComplexity)
 * @SuppressWarnings(PHPMD.NPathComplexity)
 */
function atomium_preprocess_block(array &$variables, $hook) {
  $variables['classes_array'] = \preg_grep('/^block-/', $variables['classes_array'], PREG_GREP_INVERT);
  $variables['classes_array'][] = $variables['block_html_id'];
  $variables['classes_array'][] = $variables['block_zebra'];
  $module = $variables['elements']['#block']->module;
  $delta = $variables['elements']['#block']->delta;

  if (isset($variables['block']->classes) && \is_array($variables['block']->classes)) {
    $variables['classes_array'] = \array_merge($variables['classes_array'], (array) $variables['block']->classes);
  }

  if (
    $module === 'menu_block' ||
    ($module === 'system' && $delta === 'navigation') ||
    ($module === 'system' && $delta === 'main-menu') ||
    ($module === 'system' && $delta === 'user-menu') ||
    ($module === 'admin' && $delta === 'menu')
  ) {
    $variables['theme_hook_suggestions'][] = 'block__menu';
  }

  $variables['atomium']['attributes']['wrapper']
    ->append('class', $variables['classes_array'])
    ->append('id', $variables['block_html_id'])
    ->remove('class', atomium_get_settings('preprocess.block.classes_to_remove', TRUE));

  // Add Aria Roles via attributes.
  switch ($module) {
    case 'system':
      switch ($delta) {
        case 'main':
          // Note: the "main" role goes in the page.tpl, not here.
          break;

        case 'help':
        case 'powered-by':
          $variables['atomium']['attributes']['wrapper']->append('role', 'complementary');

          break;

        default:
          // Any other "system" block is a menu block.
          $variables['atomium']['attributes']['wrapper']->append('role', 'navigation');

          break;
      }

      break;

    case 'menu':
    case 'menu_block':
    case 'blog':
    case 'book':
    case 'comment':
    case 'forum':
    case 'shortcut':
    case 'statistics':
      $variables['atomium']['attributes']['wrapper']->append('role', 'navigation');

      break;

    case 'search':
      $variables['atomium']['attributes']['wrapper']->append('role', 'search');

      break;

    case 'help':
    case 'aggregator':
    case 'locale':
    case 'poll':
    case 'profile':
      $variables['atomium']['attributes']['wrapper']->append('role', 'complementary');

      break;

    case 'node':
      switch ($delta) {
        case 'syndicate':
          $variables['atomium']['attributes']['wrapper']->append('role', 'complementary');

          break;

        case 'recent':
          $variables['atomium']['attributes']['wrapper']->append('role', 'navigation');

          break;
      }

      break;

    case 'user':
      switch ($delta) {
        case 'login':
          $variables['atomium']['attributes']['wrapper']->append('role', 'form');

          break;

        case 'new':
        case 'online':
          $variables['atomium']['attributes']['wrapper']->append('role', 'complementary');

          break;
      }

      break;
  }

  $variables['atomium']['attributes']['wrapper']->append('class', drupal_html_class('block-' . $module));

  $variables['title']['#markup'] = '';
  if ($variables['block']->subject) {
    $variables['title']['#markup'] = $variables['block']->subject;
  }
}
