<?php

namespace Drupal\atsmarttag_domain\Form;

use Drupal\atsmarttag\Form\ATSmartTagDialog;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Config\ConfigFactoryInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Routing\RequestContext;

/**
 * Class DomainConfigSettingsForm.
 *
 * @package Drupal\atsmarttag_domain\Form
 */
class DomainSmartTagSettingsForm extends ATSmartTagDialog {

  const ATSMARTTAG_DOMAIN_SETTINGS = 'atsmarttag_domain.settings';

  /**
   * The request context.
   *
   * @var \Drupal\Core\Routing\RequestContext
   */
  protected $requestContext;

  /**
   * Constructs a DomainSmartTagSettingsForm object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The factory for configuration objects.
   * @param \Drupal\Core\Routing\RequestContext $request_context
   *   The request context.
   */
  public function __construct(ConfigFactoryInterface $config_factory, RequestContext $request_context) {
    parent::__construct($config_factory);
    $this->requestContext = $request_context;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
        $container->get('config.factory'),
        $container->get('router.request_context')
    );
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    $domain_id = $this->getRequest()->get('domain_id');
    return [
      self::ATSMARTTAG_DOMAIN_SETTINGS . '.' . $domain_id,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'atsmarttag_domain_settings_form';
  }

  /**
   * Get configuration.
   * @return \Drupal\Core\Config\Config|\Drupal\Core\Config\ImmutableConfig
   */
  protected function getConfig() {
    $domain_id = $this->getRequest()->get('domain_id');
    return $this->config(
      self::ATSMARTTAG_DOMAIN_SETTINGS . '.' . $domain_id);
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $domain_id = $this->getRequest()->get('domain_id');

    $form['domain'] = [
      '#prefix' => '<p>',
      '#suffix' => '</p>',
      '#markup' => t('Domain: @domain_id', ['@domain_id' => $domain_id]),
      '#weight' => -100,
    ];

    return parent::buildForm($form, $form_state);
  }

  protected function getTagFilename() {
    $domain_id = $this->getRequest()->get('domain_id');
    return 'smarttag.' . $domain_id . '.js';
  }

  protected function getTagLibrary($mode) {
    $domain_id = $this->getRequest()->get('domain_id');
    switch ($mode) {
      case 'generic':
        $library = 'atsmarttag/smarttag.js';
        break;
      case 'url':
        $library = 'atsmarttag/smarttag_url.' . $domain_id;
        break;
      case 'file':
        $library = 'atsmarttag/smarttag_file.' . $domain_id;
        break;
      default:
        $library = '';
    }
    return $library;
  }

}
