<?php

namespace Drupal\attachinline\Asset;

use Drupal\Core\Asset\LibraryDiscoveryInterface;
use Drupal\Core\Cache\CacheCollectorInterface;
use Drupal\Core\DestructableInterface;

/**
 * Library Discovery decorator to create virtual head libraries.
 *
 * @package Drupal\attachinline\Asset
 */
class LibraryDiscoveryDecorator implements LibraryDiscoveryInterface, CacheCollectorInterface, DestructableInterface {

  /**
   * The decorated LibraryDiscover Service.
   *
   * @var \Drupal\Core\Asset\LibraryDiscoveryInterface&\Drupal\Core\Cache\CacheCollectorInterface
   */
  private $decorated;

  /**
   * LibraryDiscoveryDecorator constructor.
   *
   * @param \Drupal\Core\Asset\LibraryDiscoveryInterface $libraryDiscovery
   *   The Library Discovery Service to decorate.
   */
  public function __construct(LibraryDiscoveryInterface $libraryDiscovery) {
    $this->decorated = $libraryDiscovery;
  }

  /**
   * {@inheritDoc}
   */
  public function getLibrariesByExtension($extension) {
    return $this->decorated->getLibrariesByExtension($extension);
  }

  /**
   * {@inheritDoc}
   */
  public function getLibraryByName($extension, $name) {

    // Return a proxy library that moves its dependency to the header.
    if ($extension == 'attachinline') {
      return [
        'header' => TRUE,
        'dependencies' => [
          $name,
        ],
        'js' => [],
      ];
    }

    return $this->decorated->getLibraryByName($extension, $name);
  }

  /**
   * {@inheritDoc}
   */
  public function clearCachedDefinitions() {
    $this->decorated->clearCachedDefinitions();
  }

  /**
   * {@inheritdoc}
   */
  public function clear() {
    $this->decorated->clear();
  }

  /**
   * {@inheritdoc}
   */
  public function get($key) {
    $this->decorated->get($key);
  }

  /**
   * {@inheritdoc}
   */
  public function set($key, $value) {
    $this->decorated->set($key, $value);
  }

  /**
   * {@inheritdoc}
   */
  public function delete($key) {
    $this->decorated->delete($key);
  }

  /**
   * {@inheritdoc}
   */
  public function has($key) {
    $this->decorated->has($key);
  }

  /**
   * {@inheritdoc}
   */
  public function reset() {
    $this->decorated->reset();
  }

  /**
   * {@inheritdoc}
   */
  public function destruct() {
    $this->decorated->destruct();
  }

}
