<?php

declare(strict_types=1);

namespace Drupal\attempt_mgmt;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

/**
 * Defines a class to build a listing of attempt type entities.
 *
 * @see \Drupal\attempt_mgmt\Entity\AttemptType
 */
final class AttemptTypeListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header['label'] = $this->t('Label');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    $row['label'] = $entity->label();
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function render(): array {
    $build = parent::render();

    $build['table']['#empty'] = $this->t(
      'No attempt types available. <a href=":link">Add attempt type</a>.',
      [':link' => Url::fromRoute('entity.attempt_mgmt_attempt_type.add_form')->toString()],
    );

    return $build;
  }

}
