<?php

declare(strict_types=1);

namespace Drupal\attempt_mgmt\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBundleBase;

/**
 * Defines the Attempt type configuration entity.
 *
 * @ConfigEntityType(
 *   id = "attempt_mgmt_attempt_type",
 *   label = @Translation("Attempt type"),
 *   label_collection = @Translation("Attempt types"),
 *   label_singular = @Translation("attempt type"),
 *   label_plural = @Translation("attempts types"),
 *   label_count = @PluralTranslation(
 *     singular = "@count attempts type",
 *     plural = "@count attempts types",
 *   ),
 *   handlers = {
 *     "form" = {
 *       "add" = "Drupal\attempt_mgmt\Form\AttemptTypeForm",
 *       "edit" = "Drupal\attempt_mgmt\Form\AttemptTypeForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm",
 *     },
 *     "list_builder" = "Drupal\attempt_mgmt\AttemptTypeListBuilder",
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider",
 *     },
 *   },
 *   admin_permission = "administer attempt_mgmt_attempt types",
 *   bundle_of = "attempt_mgmt_attempt",
 *   config_prefix = "attempt_mgmt_attempt_type",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid",
 *   },
 *   links = {
 *     "add-form" = "/admin/structure/attempt_mgmt_attempt_types/add",
 *     "edit-form" = "/admin/structure/attempt_mgmt_attempt_types/manage/{attempt_mgmt_attempt_type}",
 *     "delete-form" = "/admin/structure/attempt_mgmt_attempt_types/manage/{attempt_mgmt_attempt_type}/delete",
 *     "collection" = "/admin/structure/attempt_mgmt_attempt_types",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "uuid",
 *   },
 * )
 */
final class AttemptType extends ConfigEntityBundleBase {

  /**
   * The machine name of this attempt type.
   */
  protected string $id;

  /**
   * The human-readable name of the attempt type.
   */
  protected string $label;

}
