<?php

namespace Drupal\attempt_mgmt;

use Drupal\attempt_mgmt\Utility\AttemptMgmtField;

/**
 * Provides property names for attempt settings field values.
 */
class FieldHelper {

  /**
   * Gets the property name matching the given Bigbluebutton field value.
   *
   * @param string $field
   *   An attempt setting field.
   *
   * @return string
   *   The property name.
   */
  public static function getPropertyName($field) {
    $property_mapping = [
      AttemptMgmtField::ENABLED => 'enabled',
      AttemptMgmtField::LIMIT => 'limit',
      AttemptMgmtField::FORCE_NEW_ATTEMPT => 'force_new_attempt',
      AttemptMgmtField::GRADING_METHOD => 'grading_method',
      AttemptMgmtField::DISPLAY_STATUS => 'display_status',
      AttemptMgmtField::ATTEMPT_CONFIRM_DELAY => 'attempt_confirm_delay',
      AttemptMgmtField::LOCK => 'lock',
    ];

    return $property_mapping[$field] ?? NULL;
  }
  
}
