<?php

declare(strict_types=1);

namespace Drupal\attempt_mgmt\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Attempt Management settings for this site.
 */
final class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'attempt_mgmt_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['attempt_mgmt.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {

    $form['attempt_question'] = [
      '#required' => TRUE,
      '#type' => 'textarea',
      '#title' => $this->t('Attempt question'),
      '#maxlength' => 255,
      '#default_value' => $this->config('attempt_mgmt.settings')->get('attempt_question'),
    ];
    
    $form['proceed_attempt_label'] = [
      '#required' => TRUE,
      '#type' => 'textfield',
      '#title' => $this->t('Proceed attempt label'),
      '#default_value' => $this->config('attempt_mgmt.settings')->get('proceed_attempt_label'),
    ];

    $form['start_new_attempt_label'] = [
      '#required' => TRUE,
      '#type' => 'textfield',
      '#title' => $this->t('Start new attempt label'),
      '#default_value' => $this->config('attempt_mgmt.settings')->get('start_new_attempt_label'),
    ];    

    $form['attempt_limit_exceeded'] = [
      '#required' => TRUE,
      '#type' => 'textarea',
      '#title' => $this->t('Attempt limit exceeded'),
      '#maxlength' => 255,
      '#default_value' => $this->config('attempt_mgmt.settings')->get('attempt_limit_exceeded'),
    ];

    return parent::buildForm($form, $form_state);

  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state): void {
    // @todo Validate the form here.
    // Example:
    // @code
    //   if ($form_state->getValue('example') === 'wrong') {
    //     $form_state->setErrorByName(
    //       'message',
    //       $this->t('The value is not correct.'),
    //     );
    //   }
    // @endcode
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('attempt_mgmt.settings')
      ->set('attempt_question', $form_state->getValue('attempt_question'))
      ->set('proceed_attempt_label', $form_state->getValue('proceed_attempt_label'))
      ->set('start_new_attempt_label', $form_state->getValue('start_new_attempt_label'))
      ->set('attempt_limit_exceeded', $form_state->getValue('attempt_limit_exceeded'))     
      ->save();
    parent::submitForm($form, $form_state);
  }

}
