<?php

namespace Drupal\attempt_mgmt\Plugin;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Entity\EntityFieldManagerInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\attempt_mgmt\AttemptFactory;

/**
 * Base class for Attempt processing plugin plugins.
 */
abstract class AttemptProcessingBase extends PluginBase implements AttemptProcessingInterface, ContainerFactoryPluginInterface {

  use StringTranslationTrait;

  /**
   * The name of the provider that owns this filter.
   *
   * @var string
   */
  public $provider; 

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * The entity field manager.
   *
   * @var \Drupal\Core\Entity\EntityFieldManagerInterface
   */  
  protected $entityFieldManager;

  /**
   * The attempt factory service.
   *
   * @var \Drupal\attempt_mgmt\AttemptFactory
   */  
  protected $attemptFactory;


  /**
   * AttemptProcessingBase constructor.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin_id for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   * @param \Drupal\Core\Entity\EntityFieldManagerInterface $entity_field_manager
   *   The entity field manager.
   * @param \Drupal\attempt_mgmt\AttemptFactory $attempt_factory
   *   The attempt factory service.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    EntityTypeManagerInterface $entity_type_manager,
    EntityFieldManagerInterface $entity_field_manager,
    AttemptFactory $attempt_factory
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->entityTypeManager = $entity_type_manager;
    $this->entityFieldManager = $entity_field_manager;
    $this->attemptFactory = $attempt_factory;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('entity_type.manager'),
      $container->get('entity_field.manager'),
      $container->get('attempt_mgmt.factory'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function setAttemptToActive(array $data): bool {
    return FALSE;
  }    

  public function validateAttempt(array $data, $entity, $user_id, $session_id) {
    return TRUE;    
  }


}
