<?php

namespace Drupal\attempt_mgmt\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Form\FormStateInterface;

/**
 * Defines an interface for Attempt processing plugins.
 */
interface AttemptProcessingInterface extends PluginInspectionInterface {

  /**
   * Generates an attempt plugin's settings form.
   *
   * @param array $form
   *   A minimally prepopulated form array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The state of the (entire) configuration form.
   *
   * @return array
   *   The $form array with additional form elements for the settings of this
   *   filter. The submitted form values should match $this->settings.
   */
  public function settingsForm();  

  /**
   * Determines if the attempt will be set to active.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity object.
   *
   * @return bool
   *   TRUE if the attempt should be set to active.
   */
  public function setAttemptToActive(array $data): bool;

}
