<?php

namespace Drupal\attempt_mgmt\Plugin;

use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Component\Utility\Html;

/**
 * Provides the Attempt processing plugin manager.
 */
class AttemptProcessingManager extends DefaultPluginManager {

  /**
   * Constructor for AttemptProcessingManager objects.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/AttemptProcessing', $namespaces, $module_handler, 'Drupal\attempt_mgmt\Plugin\AttemptProcessingInterface', 'Drupal\attempt_mgmt\Annotation\AttemptProcessing');

    $this->alterInfo('attempt_mgmt_attempt_processing_info');
    $this->setCacheBackend($cache_backend, 'attempt_mgmt_attempt_processing_plugins');
  }

  /**
   * Retrieves an options list of available plugins.
   *
   * @param array $entities
   *   Value of activity_bundle_entities array with "entity.bundle" values.
   *
   * @return string[]
   *   An associative array mapping the IDs of all available plugins to
   *   their labels.
   */
  public function getOptionsList(array $entities = []) {
    $options = [];

    foreach ($entities as $entity) {
      $entity = explode(':', $entity);
      $entity_type = $entity[0];
      $bundle = $entity[1];
      // Get all entity condition plugin definitions.
      foreach ($this->getDefinitions() as $plugin_id => $plugin_definition) {
        if (isset($plugin_definition['entities'][$entity_type])) {
          // If only entity type is set in plugin.
          if (empty($plugin_definition['entities'][$entity_type])) {
            $options[$plugin_id] = Html::escape($plugin_definition['label']);
          }
          // If entity type and bundle(s) are set in plugin.
          else {
            if (in_array($bundle, $plugin_definition['entities'][$entity_type])) {
              $options[$plugin_id] = Html::escape($plugin_definition['label']);
            }
          }
        }
      }
    }

    // Let's filter now by actions
    if (!empty($actions)) {
      foreach ($actions as $action) {    
        foreach ($this->getDefinitions() as $plugin_id => $plugin_definition) {
          if (!in_array($action, $plugin_definition['actions'])) {
            unset($options[$plugin_id]);
          }
        }
      }
    }

    return $options;
  }

}
