<?php

declare(strict_types=1);

namespace Drupal\attempt_mgmt\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Plugin implementation of the 'New attempt button' formatter.
 *
 * @FieldFormatter(
 *   id = "attempt_mgmt_settings_default",
 *   label = @Translation("Attempt management default"),
 *   field_types = {"attempt_mgmt_attempt_settings"},
 * )
 */
final class AttemptMgmtSettingsDefaultFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public static function defaultSettings(): array {
    $setting = [];
    return $setting + parent::defaultSettings();
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state): array {
    // $elements['foo'] = [
    //   '#type' => 'textfield',
    //   '#title' => $this->t('Foo'),
    //   '#default_value' => $this->getSetting('foo'),
    // ];
    // return $elements;
  }

  /**
   * {@inheritdoc}
   */
  public function settingsSummary(): array {
    return [
      $this->t('Foo: @foo', ['@foo' => $this->getSetting('foo')]),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $element = [];
    // foreach ($items as $delta => $item) {
    //   $element[$delta] = [
    //     '#markup' => $item->value,
    //   ];
    // }
    return $element;
  }

}
