<?php

namespace Drupal\audio_clips\Controller;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Url;
use Drupal\Core\Entity\EntityInterface;

/**
 * Defines a class to build a listing of audio clip type entities.
 */
class AudioClipTypeListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header = [];
    $header['name'] = t('Name');
    $header['description'] = [
      'data' => $this->t('Description'),
      'class' => [RESPONSIVE_PRIORITY_MEDIUM],
    ];
    $header['min_duration'] = [
      'data' => $this->t('Min Duration (s)'),
    ];
    $header['max_duration'] = [
      'data' => $this->t('Max Duration (s)'),
    ];

    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row['title'] = [
      'data' => $entity->label(),
      'class' => ['menu-label'],
    ];
    $row['description']['data'] = ['#markup' => $entity->getDescription()];
    $row['min_duration'] = $entity->getMinDuration();
    $row['max_duration'] = $entity->getMaxDuration();

    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    $build = parent::render();
    $build['table']['#empty'] = $this->t('No audio clip available. <a href=":link">Add audio clip type</a>.', [
      ':link' => Url::fromRoute('audio_clip.type_add')->toString(),
    ]);
    return $build;
  }

}
