<?php

namespace Drupal\audio_clips\FFMpeg;

/**
 * AudioFile Class.
 *
 * Use FFMpeg to clip audio and FFProbe to get file infos.
 */
class AudioFile {

  /**
   * The AudioFile path.
   *
   * @var string
   */
  public string $path;

  /**
   * Constructs the service.
   *
   * @param string $path
   *   The audio file path.
   */
  public function __construct(string $path) {
    if (!file_exists($path)) {
      throw new \InvalidArgumentException("File not found : $path");
    }

    $this->path = $path;
  }

  /**
   * Clip Audio and save clip in new audio file.
   *
   * @param int $start_time
   *   The start time in seconds.
   * @param int $end_time
   *   The end time in seconds.
   * @param string $output_path
   *   The destination path.
   *
   * @return int
   *   Return status code of the shell command.
   */
  public function processClipAudio(int $start_time, int $end_time, $output_path): int {
    // -y to replace file if already exist
    // @todo make it cleaner
    $command = "ffmpeg -y -i " . escapeshellarg($this->path) .
     " -ss {$start_time} -to {$end_time} -c copy " . escapeshellarg($output_path);

    $return_code = 0;
    $output = [];
    exec($command, $output, $return_code);
    return $return_code;
  }

  /**
   * Get audio duration time in sec.
   *
   * @return float
   *   Return audio duration value.
   */
  public function getAudioDuration(): float {
    $command = "ffprobe -i " . escapeshellarg($this->path) . " -show_entries format=duration -v quiet -of csv='p=0'";
    $duration = shell_exec($command);
    return (float) $duration;
  }

  /**
   * Get audio file format.
   *
   * @return string
   *   Return audio file format.
   */
  public function getAudioFormat(): string {
    $command = "ffprobe -i " . escapeshellarg($this->path) . " -show_entries format=format_name -v quiet -of csv='p=0'";
    $format = shell_exec($command);
    return str_replace("\n", "", $format);
  }

}
