<?php

namespace Drupal\audio_clips\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityStorageInterface;
use Drupal\Core\Field\BaseFieldDefinition;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Defines the audio_clip entity class.
 *
 * @ContentEntityType(
 *   id = "audio_clip",
 *   label = @Translation("Audio Clip"),
 *   bundle_label = @Translation("Audio Clip type"),
 *   handlers = {
 *     "storage" = "Drupal\Core\Entity\Sql\SqlContentEntityStorage",
 *     "view_builder" = "Drupal\Core\Entity\EntityViewBuilder",
 *     "access" = "Drupal\Core\Entity\EntityAccessControlHandler",
 *     "form" = {
 *       "default" = "Drupal\Core\Entity\ContentEntityForm",
 *       "delete" = "Drupal\Core\Entity\ContentEntityConfirmFormBase",
 *       "edit" = "Drupal\Core\Entity\ContentEntityForm"
 *     }
 *   },
 *   base_table = "audio_clip",
 *   data_table = "audio_clip_field_data",
 *   revision_table = "audio_clip_revision",
 *   revision_data_table = "audio_clip_field_revision",
 *   fieldable = TRUE,
 *   translatable = TRUE,
 *   entity_keys = {
 *     "id" = "acid",
 *     "bundle" = "type",
 *     "revision" = "vid",
 *     "langcode" = "langcode",
 *     "uuid" = "uuid"
 *   },
 *   revision_metadata_keys = {
 *     "revision_timestamp" = "revision_timestamp",
 *     "revision_uid" = "revision_uid",
 *     "revision_log" = "revision_log"
 *   },
 *   bundle_entity_type = "audio_clip_type",
 *   permission_granularity = "entity_type",
 *   admin_permission = "administer audio clip",
 *   links = {
 *   }
 * )
 */
class AudioClip extends ContentEntityBase implements ContentEntityInterface {

  /**
   * {@inheritdoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type) {
    $fields = [];

    $fields['acid'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Audi Clip ID'))
      ->setDescription(t('The audio clip ID.'))
      ->setReadOnly(TRUE)
      ->setSetting('unsigned', TRUE);

    $fields['uuid'] = BaseFieldDefinition::create('uuid')
      ->setLabel(t('UUID'))
      ->setDescription(t('The audio clip UUID.'))
      ->setReadOnly(TRUE);

    $fields['vid'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Revision ID'))
      ->setDescription(t('The audio clip revision ID.'))
      ->setReadOnly(TRUE)
      ->setSetting('unsigned', TRUE);

    $fields['type'] = BaseFieldDefinition::create('entity_reference')
      ->setLabel(t('Type'))
      ->setDescription(t('The audio clip type.'))
      ->setSetting('target_type', 'audio_clip_type')
      ->setReadOnly(TRUE);

    $fields['langcode'] = BaseFieldDefinition::create('language')
      ->setLabel(t('Language code'))
      ->setDescription(t('The audio clip language code.'))
      ->setRevisionable(TRUE);

    $fields['original_id'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Entity ID'))
      ->setDescription(t('ID of the original audio file.'))
      ->setSetting('unsigned', TRUE)
      ->setRevisionable(TRUE)
      ->setReadOnly(TRUE);

    $fields['target_id'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Target ID'))
      ->setDescription(t('ID of the audio clip file.'))
      ->setSetting('unsigned', TRUE)
      ->setRevisionable(TRUE)
      ->setReadOnly(TRUE);

    $fields['start_time'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Start Time'))
      ->setDescription(t('The clip start time in seconds.'))
      ->setRevisionable(TRUE)
      ->setReadOnly(TRUE)
      ->setSetting('unsigned', TRUE);

    $fields['end_time'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('End Time'))
      ->setDescription(t('The clip end time in seconds.'))
      ->setRevisionable(TRUE)
      ->setReadOnly(TRUE)
      ->setSetting('unsigned', TRUE);

    $fields['revision_timestamp'] = BaseFieldDefinition::create('created')
      ->setLabel(t('Revision timestamp'))
      ->setDescription(t('The time that the current revision was created.'))
      ->setRevisionable(TRUE);

    $fields['revision_uid'] = BaseFieldDefinition::create('entity_reference')
      ->setLabel(t('Revision author ID'))
      ->setDescription(t('The user ID of the author of the current revision.'))
      ->setSetting('target_type', 'user')
      ->setRevisionable(TRUE);

    $fields['revision_log'] = BaseFieldDefinition::create('string_long')
      ->setLabel(t('Revision Log'))
      ->setDescription(t('The log entry explaining the changes in this revision.'))
      ->setRevisionable(TRUE);

    return $fields;
  }

  /**
   * {@inheritdoc}
   */
  public function setRevisionUserId($user_id) {
    $this->set('revision_uid', $user_id);
  }

  /**
   * {@inheritdoc}
   */
  public function setRevisionLogMessage($message) {
    $this->set('revision_log', $message);
  }

  // @todo manage deletetion of clip file created

}
