<?php

namespace Drupal\audio_clips;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface defining a audio clip type entity.
 */
interface AudioClipTypeInterface extends ConfigEntityInterface {

  /**
   * Get duration of this audio clip type.
   *
   * @return int|null
   *   The duration of this audio clip type.
   */
  public function getMinDuration();

  /**
   * Get max duration of this audio clip type.
   *
   * @return int|null
   *   The max duration of this audio clip type.
   */
  public function getMaxDuration();

}
