<?php

declare(strict_types=1);

declare(strict_types=1);

namespace Drupal\auditfiles\Batch;

use Drupal\auditfiles\Auditor\AuditFilesMergeFileReferences;
use Drupal\Component\Utility\Html;

/**
 * Process batch files.
 *
 * @todo Refactor to make a Factory Worker class.
 */
final class AuditFilesMergeFileReferencesBatchProcess {

  /**
   * Constructs a new AuditFilesMergeFileReferencesBatchProcess.
   *
   * @param \Drupal\auditfiles\Auditor\AuditFilesMergeFileReferences $mergeFileReferences
   *   Injected auditfiles.merge_file_references service.
   * @param int $fileId
   *   The File entity ID to delete.
   * @param int $mergedFileId
   *   The File entity ID to merge.
   */
  final protected function __construct(
    protected AuditFilesMergeFileReferences $mergeFileReferences,
    protected int $fileId,
    protected int $mergedFileId,
  ) {
  }

  /**
   * The batch process for deleting the file.
   *
   * @param int $fileId
   *   The file ID of the file to merge the other into.
   * @param int $mergedFileId
   *   The file ID of the files to merge.
   * @param array $context
   *   Used by the Batch API to keep track of and pass data from one operation
   *   to the next.
   */
  public static function create(int $fileId, int $mergedFileId, array &$context): void {
    (new static(
      static::getService(), $fileId, $mergedFileId,
    ))->dispatch($context);
  }

  /**
   * Processes the file IDs to delete and merge.
   *
   * @param array $context
   *   Batch context.
   */
  protected function dispatch(array &$context): void {
    $this->mergeFileReferences->auditfilesMergeFileReferencesBatchMergeProcessFile($this->fileId, $this->mergedFileId);
    $context['results'][] = Html::escape($this->fileId);
    $context['results'][] = Html::escape($this->mergedFileId);
    $context['message'] = \t(
      'Merged file ID %file_being_merged into file ID %file_being_kept.',
      [
        '%file_being_kept' => $this->fileId,
        '%file_being_merged' => $this->mergedFileId,
      ]
    );
  }

  /**
   * Gets the related audit files service.
   */
  protected static function getService(): AuditFilesMergeFileReferences {
    return \Drupal::service('auditfiles.merge_file_references');
  }

}
