<?php

declare(strict_types=1);

namespace Drupal\auditfiles\Reference;

use Drupal\file\Entity\File;
use Drupal\file\FileInterface;

/**
 * Represents a file entity.
 */
final class FileEntityReference implements ReferenceInterface {

  /**
   * Constructs a new FileEntityReference.
   */
  private function __construct(
    private int $id,
  ) {
  }

  public static function create(int $id): static {
    return new static($id);
  }

  /**
   * @return int
   */
  public function getId(): int {
    return $this->id;
  }

  public function getFile(): ?FileInterface {
    return File::load($this->id);
  }

  public function __toString(): string {
    return sprintf('File entity: %s', $this->id);
  }

}
