<?php

namespace Drupal\augmentor\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Wraps an augmentor input alter event for event listeners.
 */
class AugmentorInputEvent extends Event {

  const ALTER = 'augmentor.input.alter';

  /**
   * The augmentor input.
   *
   * @var mixed
   */
  protected $input;

  /**
   * Constructs an augmentor input event object.
   *
   * @param mixed $input
   *   Augmentor input.
   */
  public function __construct($input) {
    $this->input = $input;
  }

  /**
   * Get the augmentor input.
   */
  public function getInput() {
    return $this->input;
  }

  /**
   * Set the augmentor input.
   */
  public function setInput($input) {
    $this->input = $input;
  }

}
