<?php

namespace Drupal\augmentor\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Wraps an augmentor output alter event for event listeners.
 */
class AugmentorOutputEvent extends Event {
  const ALTER = 'augmentor.output.alter';

  /**
   * The augmentor output.
   *
   * @var mixed
   */
  protected $output;

  /**
   * Constructs an augmentor output alter event object.
   *
   * @param mixed $output
   *   Augmentor output.
   */
  public function __construct($output) {
    $this->output = $output;
  }

  /**
   * Get the augmentor output.
   */
  public function getOutput() {
    return $this->output;
  }

  /**
   * Set the augmentor output.
   */
  public function setOutput($output) {
    $this->output = $output;
  }

}
