Drupal8 Plugin for Auth0
====

Single Sign On for Enterprises + Social Login + User/Passwords. For all your Drupal instances. Powered by Auth0.

Demo: <http://auth0-drupal.azurewebsites.net>

[Drupal Readme](https://github.com/auth0/auth0-drupal/blob/master/README.txt)

## Compatibility

### Drupal 8

The `v2` targets support for Drupal 8.

### Drupal 7

The `v1` targets support for Drupal 7. Also, you can get the code from the `1.x.x` branch in this repo.

## Scenarios

### Single Sign On across Multiple Drupal

If you have multiple Drupal instances and you want users to have a single User/Password among them, you can use Auth0 as the central user store for all.

![](https://docs.google.com/drawings/d/1O-TMkAaEL1ibLs2gqHVjcLVGRnAERB5wlWGaNPLDgiQ/pub?w=865&amp;h=841)

### Integrating with Enterprise

Allow users on enterprise identity system to login to Drupal with their existing corporate credentials.

![](https://docs.google.com/drawings/d/1X2DwwR0TF5TYk5opSoLfEVe5FyHRMBOKEvWQGDOTVfo/pub?w=1006&amp;h=702)

### Integrating with APIs

Call Facebook, Google, Salesforce, LinkedIn and other OAuth APIs from Drupal. Auth0 gives you the `access_token`, you just need to call the APIs you want.

![](https://docs.google.com/drawings/d/1tXgoEiBaPNb49IgMwA82gOwKVCBTDdGOrQ9mF8cH4bs/pub?w=888&amp;h=785)

## Screenshots

Login Widget

![](https://cloudup.com/cSdXE0fJfgt+)

Basic Settings

![](https://cloudup.com/coahi7q-9tV+)

Advanced Settings 

![](https://cloudup.com/csJdSV841Lh+)


## Issue Reporting

If you have found a bug or if you have a feature request, please report them at this repository issues section. Please do not report security vulnerabilities on the public GitHub issue tracker. The [Responsible Disclosure Program](https://auth0.com/whitehat) details the procedure for disclosing security issues.

## Author

[Auth0](auth0.com)

## License

This project is licensed under the [GPL](http://www.gnu.org/licenses/gpl.html).
