<?php

// make sure that our precanned action exists
$precanned = db_result(db_query("SELECT aid FROM {actions} WHERE func = '%s'", 'action_auth_report_notify_submitter'));
if (!$precanned) _auth_create_precanned_action();  


/**
 * Define email action to send email notification on complettion of report.
*/

function action_auth_report_notify_submitter($op, $edit = array(), $node) {
  global $variables;
  
  switch ($op) {
    case 'metadata':
      return array(
        'description'  => t("Authenticate: Send notification to submitter"),
        'type'         => t('Email'),
        'batchable'    => false,
        'configurable' => TRUE,
      );
    
    case 'do':
      $site_name = variable_get('site_name', 'Drupal');
      $from = "$site_name <". variable_get('site_mail', ini_get('sendmail_from')) .'>';
      $subject = module_invoke('token', 'replace', $edit['subject'], 'node', $node);
      $message = module_invoke('token', 'replace', $edit['message'], 'node', $node);
       
      $name = $variables['auth_submitter_name'];
      $mail = $variables['auth_submitter_mail'];
      $path = $variables['auth_report_path'];
      
      $subject = str_replace(array('%auth_submitter_name', '%auth_report_path'), array($name, $path), $subject); 
      $message = str_replace(array('%auth_submitter_name', '%auth_report_path'), array($name, $path), $message); 
 
      if (drupal_mail('auth_report_complete_notice', $mail, $subject, $message, $from)) {
        watchdog('authenticate', t('Sent report complete notice to %user <%email>', 
          array('%user' => $name, '%email' => $mail)), WATCHDOG_NOTICE);
      }
      else {
        watchdog('authenticate', t('Unable to send email to %user <%email>',
          array('%user' => $name, '%email' => $mail)), WATCHDOG_ERROR);
      }
      break;

    // return an HTML config form for the action
    case 'form':
      $form = array();
      $form['subject'] = array(
        '#type'          => 'textfield',
        '#title'         => t('Subject'),
        '#required'      => TRUE,
        '#default_value' => $edit['subject'],
        '#size'          => '80',
        '#maxlength'     => '254',
        '#description' => t('The subject of the email message. You may include "tokens" in this field which will be replaced with their actual
          values. Useful tokens include: [nid], [body], [teaser], [title], [url], [site-name]. This list is not comprehensive. For a complete
          list of available tokens, see the !token_definition_reference page.'
          , array('!token_definition_reference' => l(t('token definition reference'), 'library/712'))
        ),
      );
      $form['message'] = array(
        '#type'          => 'textarea',
        '#title'         => t('Message'),
        '#required'      => TRUE,
        '#default_value' => $edit['message'],
        '#cols'          => '80',
        '#rows'          => '20',
        '#description' => t('The body of the email message. You may include "tokens" in this field which will be replaced with their actual
          values. Useful tokens include: [nid], [body], [teaser], [title], [url], [site-name]. This list is not comprehensive. For a complete
          list of available tokens, see the !token_definition_reference page. You may also use %auth_submitter_name, 
          %auth_submitter_mail and %auth_report_path for variables specific to the Authenticate module.'
          , array('!token_definition_reference' => l(t('token definition reference'), 'library/712'))
        ),
      );

      return $form;

    // validate the HTML form
    case 'validate':
      return TRUE;

    // process the HTML form to store configuration
    case 'submit':
      $params = array(
        'subject'    => $edit['subject'],
        'message'    => $edit['message'],
      );

      return $params;
  }
} 


function action_auth_report_notify($op, $edit = array(), $node) {
  global $variables;
  
  switch ($op) {
    case 'metadata':
      return array(
        'description'  => t("Authenticate: Send notification email"),
        'type'         => t('Email'),
        'batchable'    => false,
        'configurable' => TRUE,
      );

    case 'do':
      $site_name = variable_get('site_name', 'Drupal');
      $from = "$site_name <". variable_get('site_mail', ini_get('sendmail_from')) .'>';
      $subject = module_invoke('token', 'replace', $edit['subject'], 'node', $node);
      $message = module_invoke('token', 'replace', $edit['message'], 'node', $node);
      $recipients = module_invoke('token', 'replace', $edit['recipients'], 'node', $node); 
       
      $mail = $variables['auth_submitter_mail'];
      $name = $variables['auth_submitter_name'];
      $path = $variables['auth_report_path'];
      
      $subject = str_replace(array('%auth_submitter_name', '%auth_report_path'), array($name, $path), $subject); 
      $message = str_replace(array('%auth_submitter_name', '%auth_report_path'), array($name, $path), $message); 
 
      if (drupal_mail('auth_report_complete_notice', $recipients, $subject, $message, $from)) {
        watchdog('authenticate', t('Sent report complete notice to ') . $recipients, WATCHDOG_NOTICE);
      }
      else {
        watchdog('authenticate', t('Unable to send email to ') . $recipients, WATCHDOG_ERROR);
      }
      break;

    // return an HTML config form for the action
    case 'form':
      $form = array();
      $form['recipients'] = array(
        '#type'          => 'textfield',
        '#title'         => t('Recipients'),
        '#required'      => TRUE,
        '#default_value' => $edit['recipients'],
        '#size'          => '40',
        '#maxlength'     => '254',
        '#description'   => t('Comma seperated list of recipient email addresses who should be notified when the authentication analysis is complete.'),
      );
      $form['subject'] = array(
        '#type'          => 'textfield',
        '#title'         => t('Subject'),
        '#required'      => TRUE,
        '#default_value' => $edit['subject'] ? $edit['subject'] : "Authentication Analysis has Completed",
        '#size'          => '80',
        '#maxlength'     => '254',
        '#description' => t('The subject of the email message. You may include "tokens" in this field which will be replaced with their actual
          values. Useful tokens include: [nid], [body], [teaser], [title], [url], [site-name]. This list is not comprehensive. For a complete
          list of available tokens, see the !token_definition_reference page.'
          , array('!token_definition_reference' => l(t('token definition reference'), 'library/712'))
        ),
      );
      $form['message'] = array(
        '#type'          => 'textarea',
        '#title'         => t('Message'),
        '#required'      => TRUE,
        '#default_value' => $edit['message'] ? $edit['message'] : "An authentication analysis was submitted and the results are now available at %auth_report_path.\n\r\n\rRegards,\n[site-name]",
        '#cols'          => '80',
        '#rows'          => '20',
        '#description' => t('The body of the email message. You may include "tokens" in this field which will be replaced with their actual
          values. Useful tokens include: [nid], [body], [teaser], [title], [url], [site-name]. This list is not comprehensive. For a complete
          list of available tokens, see the !token_definition_reference page. You may also use %auth_submitter_name, 
          %auth_submitter_mail and %auth_report_path for variables specific to the Authenticate module.'
          , array('!token_definition_reference' => l(t('token definition reference'), 'library/712'))
        ),
      );

      return $form;

    // validate the HTML form
    case 'validate':
      return TRUE;

    // process the HTML form to store configuration
    case 'submit':
      $params = array(
        'recipients' => $edit['recipients'],   
        'subject'    => $edit['subject'], 
        'message'    => $edit['message'],
      );

      return $params;
  }
} 

