/**
 * Authenticated proxy extension for Drupal Node.js server.
 */
var publishMessageToClient,
    settings = require('./authenticated-proxy-extension.config.js').settings,
    queryString = require('querystring'),
    urlMap = settings.urlMap || false,
    backendPath = '',
    request,
    authenticatedClients,
    map = {},
    query = '',
    options = {},
    urlMapKey = '',
    originPathParts = [],
    uidPrefix = '',
    uidSuffix = '',
    i = 0,
    user = false;

/**
 * Returns the backend base url given settings.
 */
var getBackendBaseUrl = function(settings) {
  var baseUrl = settings.scheme + '://' + settings.host;
  if (settings.scheme == 'http' && settings.port != 80) {
    baseUrl += ':' + settings.port.toString();
  }
  else if (settings.scheme == 'https' && settings.port != 443) {
    baseUrl += ':' + settings.port.toString();
  }
  baseUrl += settings.backendBaseUrl + '/';
  return baseUrl;
}

/**
 * Handle express.js requests.
 */
var handleProxyRequests = function(req, res) {
  user = authenticatedClients[req.header('authenticatedproxytoken')];
  if (user) {

    originPathParts = req.params[0].split('/').filter(function(b) { return b != '' }) || [];
    if (urlMap) {
      urlMapKey = originPathParts.shift();
      if (!urlMap[urlMapKey]) {
	res.send({'status': 'invalid url'});
	return;
      }
      map = urlMap[urlMapKey];

      backendPathParts = map.path ? map.path.split('/') : [];
      for (i = 0; i < backendPathParts; i++) {
	if (backendPathParts[i] == ':uid') {
	  backendPathParts[i] = user.uid.toString();
	}
      }
      if (map.appendOriginPath) {
        backendPathParts.concat(originPathParts);
      }
      backendPath = backendPathParts.join('/');
    }
    else {
      backendPath = req.params[0].replace(/^\//, '');
    }
    url = getBackendBaseUrl(settings) + backendPath;

    query = {};
    for (i in req.query) {
      if (typeof req.query[i] == 'string') {
	query[i] = [req.query[i]];
      }
      else {
	query[i] = req.query[i];
      }
    }
    
    if (settings.queryParams) {
      for (i in settings.queryParams) {
        query[i] = query[i] || [];
	if (typeof settings.queryParams[i] == 'string') {
	  query[i].push(settings.queryParams[i]);
	}
	else {
	  query[i].concat(settings.queryParams[i]);
	}
      }
    }

    if (map.uidQueryKey) {
      uidPrefix = map.uidPrefix || '';
      uidSuffix = map.uidSuffix || '';
      query[map.uidQueryKey] = query[map.uidQueryKey] || [];
      query[map.uidQueryKey].push(uidPrefix + user.uid.toString() + uidSuffix);
    }

    if (map.queryParams) {
      for (i in map.queryParams) {
        query[i] = query[i] || [];
	if (typeof map.queryParams[i] == 'string') {
	  query[i].push(map.queryParams[i]);
	}
	else {
	  query[i].concat(map.queryParams[i]);
	}
      }
    }

    if (settings.debug) {
      console.log(map, query);
    }

    if (query = queryString.stringify(query)) {
      url += '?' + query;
    }

    if (settings.debug) {
      console.log("Sending request to backend with url", url);
    }
    req.pipe(request(url)).pipe(res);
  }
  else {
    if (settings.debug) {
      console.log("Auth token failure, header was", req.header('authproxytoken'));
    }
    res.send({'status': 'failed authtoken'});
  }
}

exports.setup = function (config) {
  authenticatedClients = config.authenticatedClients;
  request = config.request;
};

exports.routes = [
  {path: settings.proxyBaseUrl + '*', handler: handleProxyRequests}
];

// vi:ai:expandtab:sw=2 ts=2

