/**
 * Authenticated proxy extension for Drupal Node.js server.
 */
var publishMessageToClient,
    settings = require('./authenticated-proxy-extension.config.js').settings,
    queryString = require('querystring'),
    urlMap = settings.urlMap || false,
    backendPath = '',
    request,
    authenticatedClients,
    authproxyTokens,
    map = {},
    query = '',
    suffix = '',
    prefix = '',
    options = {},
    allowedQueryKeys = [],
    urlMapKey = '',
    originPathParts = [],
    uidPrefix = '',
    uidSuffix = '',
    i = 0,
    mappedQueryKey = '',
    user = false;

/**
 * Returns the backend base url given settings.
 */
var getBackendBaseUrl = function(settings) {
  var baseUrl = settings.scheme + '://' + settings.host;
  if (settings.scheme == 'http' && settings.port != 80) {
    baseUrl += ':' + settings.port.toString();
  }
  else if (settings.scheme == 'https' && settings.port != 443) {
    baseUrl += ':' + settings.port.toString();
  }
  baseUrl += settings.backendBaseUrl + '/';
  return baseUrl;
}

/**
 * Check if an authToken is valid.
 */
var checkToken = function(token) {
  return authenticatedClients[token] || authproxyValidTokens[token];
}

/**
 * Adds auth tokens sent from the backend.
 *
 * Server.js only passes requests here with a valid serviceKey.
 */
var addAuthTokens = function(req, res) {
  var requestBody = '';
  req.setEncoding('utf8');
  req.on('data', function (chunk) {
    requestBody += chunk;
  });
  req.on('end', function () {
    try {
      var message = JSON.parse(requestBody);
      for (var i = 0; i < message.length; i++) {
        authproxyValidTokens[message[i].token] = {uid: message[i].uid};
      }
    }
    catch (exception) { }
    res.send('');
  });
}

/**
 * Handle express.js requests.
 */
var handleProxyRequests = function(req, res) {
  user = authenticatedClients[req.header('authenticatedproxytoken')];
  if (user) {

    originPathParts = req.params[0].split('/').filter(function(b) { return b != '' }) || [];
    if (urlMap) {
      urlMapKey = originPathParts.shift();
      if (!urlMap[urlMapKey]) {
        res.send({'status': 'invalid url'});
        return;
      }
      map = urlMap[urlMapKey];
      allowedQueryKeys = map.allowedQueryKeys || settings.allowedQueryKeys;

      backendPathParts = map.path ? map.path.split('/') : [];
      for (i = 0; i < backendPathParts; i++) {
        if (backendPathParts[i] == ':uid') {
          backendPathParts[i] = user.uid.toString();
        }
      }
      if (map.appendOriginPath) {
        backendPathParts.concat(originPathParts);
      }
      backendPath = backendPathParts.join('/');
    }
    else {
      backendPath = req.params[0].replace(/^\//, '');
    }
    url = getBackendBaseUrl(settings) + backendPath;

    query = {};
    for (i in req.query) {
      mappedQueryKey = i;
      suffix = '';
      prefix = '';
      if (allowedQueryKeys && !allowedQueryKeys[i]) {
        continue;
      }
      else {
        mappedQueryKey = allowedQueryKeys[i].mappedKey || i;
        suffix = allowedQueryKeys[i].suffix || '';
        prefix = allowedQueryKeys[i].prefix || '';
      }
      if (typeof req.query[i] == 'string') {
        query[mappedQueryKey] = [prefix + req.query[i] + suffix];
      }
      else {
        query[mappedQueryKey] = prefix + req.query[i] + suffix;
      }
    }

    if (settings.queryParams) {
      for (i in settings.queryParams) {
        query[i] = query[i] || [];
        if (typeof settings.queryParams[i] == 'string') {
          query[i].push(settings.queryParams[i]);
        }
        else {
          query[i].concat(settings.queryParams[i]);
        }
      }
    }

    if (map.uidQueryKey) {
      uidPrefix = map.uidPrefix || '';
      uidSuffix = map.uidSuffix || '';
      query[map.uidQueryKey] = query[map.uidQueryKey] || [];
      query[map.uidQueryKey].push(uidPrefix + user.uid.toString() + uidSuffix);
    }

    if (map.queryParams) {
      for (i in map.queryParams) {
        query[i] = query[i] || [];
        if (typeof map.queryParams[i] == 'string') {
          query[i].push(map.queryParams[i]);
        }
        else {
          query[i].concat(map.queryParams[i]);
        }
      }
    }

    if (settings.debug) {
      console.log(map, query);
    }

    if (query = queryString.stringify(query)) {
      url += '?' + query;
    }

    if (settings.debug) {
      console.log("Sending request to backend with url", url);
    }
    req.pipe(request(url)).pipe(res);
  }
  else {
    if (settings.debug) {
      console.log("Auth token failure, header was", req.header('authproxytoken'));
    }
    res.send({'status': 'failed authtoken'});
  }
}

exports.setup = function (config) {
  authenticatedClients = config.authenticatedClients;
  request = config.request;
  serverSetings = config.settings;
};

exports.routes = [
  {path: settings.proxyBaseUrl + '*', handler: handleProxyRequests},
  {path: 'auth-proxy/add-tokens', handler: addAuthTokens, type: 'post', auth: true}
];

// vi:ai:expandtab:sw=2 ts=2

