# AuthNet CIM Manager

The AuthNet CIM Manager module facilitates smooth integration with the Authorize.Net Customer Information Manager (CIM) for Drupal websites.

## Introduction

The AuthNet CIM Manager module streamlines the management of customer information through the Authorize.Net payment gateway. Its features include:

- Capture and add customer information in the authorise.net platform.
- Enhanced security and efficiency for payment processing.

## Requirements

This module requires the following dependencies:

- Authorize.Net PHP SDK (automatically installed via Composer)

## Installation

1. Download the module and place it in your Drupal installation's `modules` directory.
2. Enable the module through the Drupal administration interface or by running `drush en authnet_cim_manager` from the command line.

For more detailed installation instructions, refer to [Drupal.org documentation](https://www.drupal.org/node/895232).

## Configuration

After installation, configure the AuthNet CIM Manager module by following these steps:

1. Navigate to the module's configuration page.
2. Configure settings for customer information capture and updating.
3. Customize additional options as needed.

## Maintainers

Current maintainers for Drupal 10:

- [Prashant Singh](https://www.drupal.org/u/__iamprashant__)
