## Author Storage type with the Organization field
This example shows how to create the author storage type with the Storage organization type using the storage entity module,
and use it into the content type as the entity reference.

### Steps to add Organization Field into the Storage type
Go to Structure > Storage types > Add Storage type.
And create the organization Storage type, filling out Type label, description, etc.


- Add Organization field type according to the image below.
  ![stor_org_manage_fields.jpg](./images/stor_author_stor_org/stor_org_manage_fields.jpg "Organization Manage Fields in Storage Type")


- Configure "Manage form display" for the organization field.
  ![stor_org_manage_form_display.jpg](./images/stor_author_stor_org/stor_org_manage_form_display.jpg "Organization Manage Form Display in Storage Type")


- Configure "Manage display" for the organization field. The configurable "Organization field" format type is selected.
  ![stor_org_manage_display.jpg](./images/stor_author_stor_org/stor_org_manage_display.jpg "Organization Manage Display in Storage Type")


- In "Edit" page for the Storage author type, configure the "Pattern for automatic name generation" field using the "Browser available tokens" link provided by the "token" module.
  ![stor_token_org.jpg](./images/stor_author_stor_org/stor_token_org.jpg "Org Token in Storage Type")

### Steps to add Author Field into the Storage type
Go to Structure > Storage types > Add Storage type.
And create the author Storage type, filling out Type label, description, etc.

- Add Author field type and the above Organization Storage type as the entity reference according to the image below.
  ![stor_author_stor_org_manage_fields.jpg](./images/stor_author_stor_org/stor_author_stor_org_manage_fields.jpg "Author and Organization Storage type Manage Fields in Storage Type")


- When adding new field into the storage type, The field type, "Reference -> Storage" option in the dropdown list is selected. After that, the reference type is selected.
  ![stor_org_ref_type.jpg](./images/stor_author_stor_org/stor_org_ref_type.jpg "Storage Organization reference type  in Storage Type")


- Configure "Manage form display" for the author field. The Author widget type is configured to disable the organization field. As the organization widget type, the "inline entity form - Complex" type is selected in the dropdown list.
  ![stor_author_stor_org_manage_form_display.jpg](./images/stor_author_stor_org/stor_author_stor_org_manage_form_display.jpg "Author and Organization Storage type Manage Form Display in Storage Type")


- Configure "Manage display" for the author field. As the format type, The "Rendered entity" for the organization field is selected in the dropdown list.
  ![stor_author_stor_org_manage_display.jpg](./images/stor_author_stor_org/stor_author_stor_org_manage_display.jpg "Author and Organization Storage type Manage Display in Storage Type")


- In "Edit" page for the Storage author type, configure the "Pattern for automatic name generation" field using the "Browser available tokens" link provided by the "token" module.
  ![stor_token_author_stor_org.jpg](./images/stor_author_stor_org/stor_token_author_stor_org.jpg "Author Stor Org Token in Storage Type")

### Steps to add the above Author Storage type as the entity reference type into the Content type
Go to Structure > Content types, and click the "Add content type" button.
And create the specific content type, filling out name, Machine-readable name, description, etc.

- When adding new field into the content type, The field type, "Reference -> Storage" option in the dropdown list is selected. After that, the reference type is selected.
  ![ct_author_stor_org_select_ref_type.jpg](./images/stor_author_stor_org/ct_author_stor_org_select_ref_type.jpg "Storage Author with Organization Storage type reference type  in Content Type")


- Add the Author Storage type as the entity reference.
  ![ct_author_stor_org_manage_fields.jpg](./images/stor_author_stor_org/ct_author_stor_org_manage_fields.jpg "Author and Organization Storage type Manage Fields in Content Type")


- Configure "Manage form display" for the author field. As the widget type, the "inline entity form - Complex" is selected in the dropdown list.
  ![ct_author_stor_org_manage_form_display.jpg](./images/stor_author_stor_org/ct_author_stor_org_manage_form_display.jpg "Author and Organization Storage type Manage Form Display in Content Type")


- Configure "Manage display" for the author field. As the format type, The "Rendered entity" is selected in the dropdown list.
  ![ct_author_stor_org_manage_display.jpg](./images/stor_author_stor_org/ct_author_stor_org_manage_display.jpg "Author and Organization Storage Type Manage Display in Content Type")

### Steps to create the content for the author field using the above Content type.
Go to Content, and click the "Add content" button, and create a content using the above content type.
Two authors as examples are added.

- Edit content page for the author field.
  ![content_author_stor_org_edit_page.jpg](./images/stor_author_stor_org/content_author_stor_org_edit_page.jpg "Author and Organization Storage type Edit Page in Content")


- In "Edit" page, update the author field.
  ![content_author_stor_org_edit_author_page.jpg](./images/stor_author_stor_org/content_author_stor_org_edit_author_page.jpg "Author Upate in Edit Page in Content")


- In "Edit" page, update the organization field in the author field.
  ![content_author_stor_org_edit_org_page.jpg](./images/stor_author_stor_org/content_author_stor_org_edit_org_page.jpg "Organization Upate in Edit Page in Content")


- Display the author content in "View" page.
  ![content_author_stor_org_view_page.jpg](./images/stor_author_stor_org/content_author_stor_org_view_page.jpg "Author View Page in Content")
