# Author field module

### Background

[ORCID](https://orcid.org/), which stands for Open Researcher and Contributor ID, is a unique, persistent identifier free of charge to researchers.
It includes research institutions, publishers, funders, professional associations, service providers, and other stakeholders in the research ecosystem.
[The API tutorial](https://info.orcid.org/documentation/api-tutorials/api-tutorial-searching-the-orcid-registry/) describes how to search the ORCID Registry using the ORCID public API.

### About
Author field module provides fields that store information associated with the ORCID identifier for a researcher. It also includes a form field formatter with autocomplete capability and a display field formatter to show the ORCID ID.

### Key capabilities
- Provides a form field formatter with an ability to autocomplete researcher name as the user enters the text. The module uses ORCID API to fetch records.
- Provides a display and form field formatters to customize display of Author field, including ORCID ID.
- Provides a hook to fetch records based on search and select it, which can then be stored into other fields such as first name, last name, email, and organization name.

### Fields
- Search: Autocomplete researcher name, name identifier, organization name, etc.
- Family Name: Stores the family name.
- Given Name: Stores the given name.
- Email: Stores the email address.
- Organization Name: Stores the first current affiliation name.

### Uninstall validation
This is implemented using a drupal form where custom script is executed to delete the dependent fields from the system. Currently, "node" and "storage" types are handled for the deletion.
