<?php
/**
 * @file
 * Author Pane Popup admin configurations.
 */

/**
 * Callback function for admin setting.
 */
function author_pane_popup_admin() {
  $content_types = node_type_get_types();
  $author_pane_popup_advanced_collapsible = TRUE;
  $form['author_pane_popup'] = array(
    '#type' => 'fieldset',
    '#title' => t('Select the content types you want to enable author pane popup'),
    '#collapsible' => FALSE,
    '#collapsed' => FALSE,
  );
  foreach ($content_types as $content_type) {
    $author_pane_popup_content_types[$content_type->type] = $content_type->name;
  }
  $form['author_pane_popup']['author_pane_popup_content_types'] = array(
    '#type' => 'checkboxes',
    '#title' => t('Enable Tracking'),
    '#options' => $author_pane_popup_content_types,
  );
  $form['author_pane_popup']['author_pane_popup_content_types']['#default_value'] = array_keys(array_filter(variable_get('author_pane_popup_content_types', $form['author_pane_popup']['author_pane_popup_content_types']['#options'])));
  $form['author_pane_popup']['author_pane_popup_jquery_selectors'] = array(
    '#type' => 'textarea',
    '#title' => t('jQuery selector to trigger Author Pane Popup'),
    '#default_value' => variable_get('author_pane_popup_jquery_selectors', '.username'),
    '#description' => t('Specify jQuery identifiers. Enter one item per line. For example: <em>.username</em>. Please note: Respective HTML elements should be anchor tags which links to the user profile.'),
  );
  $form['author_pane_popup']['author_pane_popup_use_loading_image'] = array(
    '#type' => 'checkbox',
    '#title' => t('Use image instead of displaying text while loading.'),
    '#default_value' => variable_get('author_pane_popup_use_loading_image', 0),
  );
  $form['author_pane_popup']['author_pane_popup_loading_text'] = array(
    '#type' => 'textfield',
    '#title' => t('Loading Text'),
    '#default_value' => variable_get('author_pane_popup_loading_text', 'Loading...'),
    '#states' => array(
      'visible' => array(
        ':input[name="author_pane_popup_use_loading_image"]' => array('checked' => FALSE),
      ),
    ),
  );
  $form['author_pane_popup']['author_pane_popup_loading_image'] = array(
    '#type' => 'managed_file',
    '#name' => 'author_pane_popup_loading_image',
    '#title' => t('Upload Image'),
    '#description' => t("Here you can upload an image to show while Author Information loading!"),
    '#upload_location' => 'public://',
    '#upload_validators' => array(
      'file_validate_extensions' => array('gif png jpg jpeg'),
      'file_validate_image_resolution' => array('20x20', 0),
    ),
    '#states' => array(
      'visible' => array(
        ':input[name="author_pane_popup_use_loading_image"]' => array('checked' => TRUE),
      ),
      'required' => array(
        ':input[name="author_pane_popup_use_loading_image"]' => array('checked' => TRUE),
      ),
    ),
    '#process' => array('author_pane_popup_author_pane_popup_loading_image_element_process'),
  );
  $fid = variable_get('author_pane_popup_loading_image', '');
  if ($fid != '') {
    $author_pane_popup_file = file_load($fid);
    $author_pane_popup_file_uri = $author_pane_popup_file->uri;
    $author_pane_popup_file_url = file_create_url($author_pane_popup_file_uri);
    $author_pane_popup_image_variables = array(
      'path' => $author_pane_popup_file_url,
      'alt' => 'Loading...',
      'title' => 'Loading...',
      'width' => '20px',
      'height' => '20px',
    );
    $form['author_pane_popup']['author_pane_popup_loading_image']['#field_prefix'] = theme('image', $author_pane_popup_image_variables);
  }
  $form['#submit'][] = 'author_pane_popup_loading_image_form_submit';

  $qtip_instances = qtip_load_multiple();
  $qtip_instances_ops[''] = '-Select-';
  foreach ($qtip_instances as $key => $instance) {
    $qtip_instances_ops[$key] = $instance->name;
  }
  $form['author_pane_popup_style'] = array(
    '#type' => 'fieldset',
    '#title' => t('SELECT Author Pane Popup Style to use'),
    '#collapsible' => FALSE,
    '#collapsed' => FALSE,
  );
  $form['author_pane_popup_style']['author_pane_popup_qtip_instance'] = array(
    '#type' => 'select',
    '#title' => t('qTip instances'),
    '#options' => $qtip_instances_ops,
    '#default_value' => variable_get('author_pane_popup_qtip_instance', ''),
    '#description' => t('Select the qTip style to use for your Author Pane Popup. !click_here to add new qTip instances.', array('!click_here' => l(t('Click here'), 'admin/config/user-interface/qtip/list/add'))),
    '#required' => TRUE,
  );
  // Page specific visibility configurations.
  $php_access = user_access('use PHP for Author Pane Popup visibility');
  $visibility = variable_get('author_pane_popup_visibility_options', 0);
  $pages = variable_get('author_pane_popup_visibility_pages', AUTHOR_PANE_POPUP_PAGES);
  $options = array();
  $title = '';
  $description = '';
  if ($visibility == AUTHOR_PANE_POPUP_USE_PHP_FOR_TRACKING && !$php_access) {
    $form['author_pane_popup_visibility_options'] = array('#type' => 'value', '#value' => 1);
    $form['author_pane_popup_visibility_pages'] = array('#type' => 'value', '#value' => $pages);
  }
  else {
    $options = array(
      t('Every page except the listed pages'),
      t('The listed pages only'),
    );
    $description = t("Specify pages by using their paths. Enter one path per line. The '*' character is a wildcard. Example paths are %blog for the blog page and %blog-wildcard for every personal blog. %front is the front page.", array(
      '%blog' => 'blog',
      '%blog-wildcard' => 'blog/*',
      '%front' => '<front>',
    ));
    if (module_exists('php') && $php_access) {
      $options[] = t('Pages on which this PHP code returns <code>TRUE</code> (experts only)');
      $title = t('Pages or PHP code');
      $description .= ' ' . t('If the PHP option is chosen, enter PHP code between %php. Note that executing incorrect PHP code can break your Drupal site.', array('%php' => '<?php ?>'));
    }
    else {
      $title = t('Pages');
    }
  }
  $form['author_pane_popup_visibility'] = array(
    '#type' => 'fieldset',
    '#title' => t('Add Author Pane Popup to specific pages'),
    '#collapsible' => FALSE,
    '#collapsed' => FALSE,
  );
  $form['author_pane_popup_visibility']['author_pane_popup_visibility_options'] = array(
    '#type' => 'radios',
    '#options' => $options,
    '#default_value' => variable_get('author_pane_popup_visibility_options', 0),
  );
  $form['author_pane_popup_visibility']['author_pane_popup_visibility_pages'] = array(
    '#type' => 'textarea',
    '#title' => $title,
    '#default_value' => $pages,
    '#description' => $description,
    '#wysiwyg' => FALSE,
    '#rows' => 10,
  );
  if (variable_get('author_pane_popup_use_views', 0) == 1) {
    $author_pane_popup_advanced_collapsible = FALSE;
  }
  $form['author_pane_popup_advanced'] = array(
    '#type' => 'fieldset',
    '#title' => t('Advanaced'),
    '#collapsible' => $author_pane_popup_advanced_collapsible,
    '#collapsed' => $author_pane_popup_advanced_collapsible,
  );
  $form['author_pane_popup_advanced']['author_pane_popup_use_views'] = array(
    '#type' => 'checkbox',
    '#title' => t('Use !views instead of !author_pane to manipulate popup content.', array(
      '!views' => l(t('Views'), 'http://drupal.org/project/views'),
      '!author_pane' => l(t('Author Pane'), 'http://drupal.org/project/author_pane'),
    )),
    '#default_value' => variable_get('author_pane_popup_use_views', 0),
  );
  $form['author_pane_popup_advanced']['author_pane_popup_use_views_description_container'] = array(
    '#type' => 'container',
    '#states' => array(
      'visible' => array(
        ':input[name="author_pane_popup_use_views"]' => array('checked' => TRUE),
      ),
    ),
  );
  $form['author_pane_popup_advanced']['author_pane_popup_use_views_description_container']['author_pane_popup_use_views_description'] = array(
    '#markup' => t('Add/remove new fields and update the order of items in popup !here.', array('!here' => l(t('here'), 'admin/structure/views/view/author_pane_popup/edit'))),
  );
  return system_settings_form($form);
}

/**
 * Custom validation for admin setting.
 */
function author_pane_popup_admin_validate($form, &$form_state) {
  if ($form_state['values']['author_pane_popup_use_loading_image'] == 1 &&
    variable_get('author_pane_popup_loading_image', '') == '' &&
    $form_state['values']['author_pane_popup_loading_image'] == 0) {
    form_set_error('author_pane_popup_loading_image', t('Image field is required.'));
  }
}

/**
 * Function to disable default upload and remove button manged_file field.
 */
function author_pane_popup_author_pane_popup_loading_image_element_process($element, &$form_state, $form) {
  $element = file_managed_file_process($element, $form_state, $form);
  $element['upload_button']['#access'] = FALSE;
  $element['remove_button']['#access'] = FALSE;
  return $element;
}

/**
 * Custom submit handler for admin setting to manage image upload.
 */
function author_pane_popup_loading_image_form_submit($form, $form_state) {
  if (!empty($form['author_pane_popup']['author_pane_popup_loading_image']['#file'])) {
    $form['author_pane_popup']['author_pane_popup_loading_image']['#file']->status = FILE_STATUS_PERMANENT;
    file_save($form['author_pane_popup']['author_pane_popup_loading_image']['#file']);
  }
}
