<?php
/**
 * @file
 * Author Pane Popup inc.
 */

/**
 * Callback function for popup.
 */
function author_pane_popup_author_pane($account) {
  if ($user_path = drupal_lookup_path('source', $_POST['url'])) {
    $account = menu_get_object('user', 1, $user_path);
  }
  else {
    $account = menu_get_object('user', 1, $_POST['url']);
  }
  if (variable_get('author_pane_popup_use_views', 0) == 1) {
    print views_embed_view('author_pane_popup', 'block', $account->uid);
  }
  else {
    print theme('author_pane',
      array(
        'account' => $account,
        'caller' => NULL,
        'picture_preset' => 'thumbnail',
        'context' => NULL,
        'disable_css' => FALSE,
      )
    );
  }
}

/**
 * Based on visibility setting this function returns TRUE/FALSE.
 */
function author_pane_popup_visibility_pages() {
  static $page_match;
  $php_access = user_access('use PHP for Author Pane Popup visibility');

  // Cache visibility result if function is called more than once.
  if (!isset($page_match)) {

    $visibility = variable_get('author_pane_popup_visibility_options', 0);
    $setting_pages = variable_get('author_pane_popup_visibility_pages', AUTHOR_PANE_POPUP_PAGES);

    // Match path if necessary.
    if (!empty($setting_pages)) {
      // Convert path to lowercase. This allows comparison of the same path
      // with different case. Ex: /Page, /page, /PAGE.
      $pages = drupal_strtolower($setting_pages);
      if ($visibility < 2) {
        // Convert the Drupal path to lowercase.
        $path = drupal_strtolower(drupal_get_path_alias($_GET['q']));
        // Compare the lowercase internal and lowercase path alias (if any).
        $page_match = drupal_match_path($path, $pages);
        if ($path != current_path()) {
          $page_match = $page_match || drupal_match_path($_GET['q'], $pages);
        }
        // When $visibility has a value of 0, the tracking code is displayed on
        // all pages except those listed in $pages. When set to 1, it
        // is displayed only on those pages listed in $pages.
        $page_match = !($visibility xor $page_match);
      }
      elseif (module_exists('php') && $php_access) {
        $page_match = php_eval($setting_pages);
      }
      else {
        $page_match = FALSE;
      }
    }
    else {
      $page_match = TRUE;
    }

  }
  return $page_match;
}

/**
 * Passing php values to Drupal js.
 */
function author_pane_popup_load_js($author_pane_popup_js) {
  drupal_add_js(array(
    'author_pane_popup_triggers' => $author_pane_popup_js['author_pane_popup_triggers'],
    'author_pane_popup_qtip_config' => $author_pane_popup_js['author_pane_popup_qtip_instance'],
    'author_pane_popup_loading_text' => $author_pane_popup_js['author_pane_popup_loading_text'],
  ), 'setting'
  );
}

/**
 * Get trigger classes/ids.
 */
function author_pane_popup_get_triggers() {
  $trigger = variable_get('author_pane_popup_jquery_selectors', '.username' . "\n");
  $trigger = explode("\n", $trigger);
  // Trim all entries.
  $trigger = array_map('trim', $trigger);
  // Filter out empty lines.
  $trigger = array_filter($trigger);

  $triggers = array();

  foreach ($trigger as $this_trigger) {
    $triggers[] = $this_trigger;
  }
  return implode(',', $triggers);
}

/**
 * Author Pane Popup Views.
 */
function author_pane_popup_view() {
  $view = new view();
  $view->name = 'author_pane_popup';
  $view->description = 'Default view for Author Pane Popup.';
  $view->tag = 'default';
  $view->base_table = 'users';
  $view->human_name = 'Author Pane Popup';
  $view->core = 7;
  $view->api_version = '3.0';
  $view->disabled = FALSE; /* Edit this to true to make a default view disabled initially */

  /* Display: Master */
  $handler = $view->new_display('default', 'Master', 'default');
  $handler->display->display_options['use_more_always'] = FALSE;
  $handler->display->display_options['access']['type'] = 'perm';
  $handler->display->display_options['access']['perm'] = 'access user profiles';
  $handler->display->display_options['cache']['type'] = 'none';
  $handler->display->display_options['query']['type'] = 'views_query';
  $handler->display->display_options['exposed_form']['type'] = 'basic';
  $handler->display->display_options['pager']['type'] = 'some';
  $handler->display->display_options['pager']['options']['items_per_page'] = '1';
  $handler->display->display_options['style_plugin'] = 'default';
  $handler->display->display_options['row_plugin'] = 'fields';
  /* Field: User: Name */
  $handler->display->display_options['fields']['name']['id'] = 'name';
  $handler->display->display_options['fields']['name']['table'] = 'users';
  $handler->display->display_options['fields']['name']['field'] = 'name';
  $handler->display->display_options['fields']['name']['label'] = '';
  $handler->display->display_options['fields']['name']['alter']['word_boundary'] = FALSE;
  $handler->display->display_options['fields']['name']['alter']['ellipsis'] = FALSE;
  /* Field: User: Picture */
  $handler->display->display_options['fields']['picture']['id'] = 'picture';
  $handler->display->display_options['fields']['picture']['table'] = 'users';
  $handler->display->display_options['fields']['picture']['field'] = 'picture';
  $handler->display->display_options['fields']['picture']['label'] = '';
  $handler->display->display_options['fields']['picture']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['picture']['image_style'] = 'thumbnail';
  /* Field: User: Last access */
  $handler->display->display_options['fields']['access']['id'] = 'access';
  $handler->display->display_options['fields']['access']['table'] = 'users';
  $handler->display->display_options['fields']['access']['field'] = 'access';
  $handler->display->display_options['fields']['access']['label'] = 'Last seen';
  $handler->display->display_options['fields']['access']['date_format'] = 'raw time ago';
  $handler->display->display_options['fields']['access']['second_date_format'] = 'long';
  /* Field: User: Created date */
  $handler->display->display_options['fields']['created']['id'] = 'created';
  $handler->display->display_options['fields']['created']['table'] = 'users';
  $handler->display->display_options['fields']['created']['field'] = 'created';
  $handler->display->display_options['fields']['created']['label'] = 'Joined';
  $handler->display->display_options['fields']['created']['date_format'] = 'short';
  $handler->display->display_options['fields']['created']['second_date_format'] = 'long';
  /* Contextual filter: User: Uid */
  $handler->display->display_options['arguments']['uid']['id'] = 'uid';
  $handler->display->display_options['arguments']['uid']['table'] = 'users';
  $handler->display->display_options['arguments']['uid']['field'] = 'uid';
  $handler->display->display_options['arguments']['uid']['default_action'] = 'not found';
  $handler->display->display_options['arguments']['uid']['default_argument_type'] = 'fixed';
  $handler->display->display_options['arguments']['uid']['summary']['number_of_records'] = '0';
  $handler->display->display_options['arguments']['uid']['summary']['format'] = 'default_summary';
  $handler->display->display_options['arguments']['uid']['summary_options']['items_per_page'] = '25';
  /* Filter criterion: User: Active */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'users';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = '1';
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block');

  return $view;
}
