/**
 * @file
 * Author Pane Popup. author_pane_popup.js.
 */

(function ($) {

  'use strict';

  Drupal.behaviors.AuthorPanePopup = {
    attach: function (context, settings) {
      var instances = $.parseJSON(settings.instances);
      var instance = Drupal.settings.author_pane_popup_qtip_config;
      var author_pane_popup_triggers = Drupal.settings.author_pane_popup_triggers;
      var qtip_settings = (instances[instance] !== 'undefined') ? instances[instance] : '';
      $(author_pane_popup_triggers).each(function () {
        var $this = $(this);
        var url = $this.attr('href');
        if (url) {
          url = url.replace(/^\//, '');
          $this.qtip(qtip_settings);
          $this.qtip('option', 'content.text', Drupal.settings.author_pane_popup_loading_text);
          $this.qtip('option', 'content.ajax', {
            url: '/author_pane_popup/user',
            data: {url: url},
            type: 'POST'
          });
        }
      });
    }
  };
})(jQuery);
