<?php

/**
 * @file
 * Contains the config form for the authorization_code module.
 */

use Drupal\authorization_code\AuthorizationCodeConfig;

/**
 * Callback function for authorization_code_config form.
 *
 * @param array $form
 *   The initial form array.
 * @param array $form_state
 *   The form state array.
 * @return array
 *   The complete system form.
 */
function authorization_code_config_form(array $form, array &$form_state) {

  $form[AuthorizationCodeConfig::CODE_LENGTH_CONFIG_NAME] = [
    '#type' => 'textfield',
    '#title' => t('Generated code length'),
    '#default_value' => AuthorizationCodeConfig::getCodeLength(),
    '#size' => 2,
    '#maxlength' => 2,
    '#required' => TRUE,
  ];

  $form[AuthorizationCodeConfig::FLOOD_THRESHOLD_CONFIG_NAME] = [
    '#type' => 'textfield',
    '#title' => t('Flood threshold (set to 0 to disable)'),
    '#default_value' => AuthorizationCodeConfig::getFloodThreshold(),
    '#size' => 2,
    '#maxlength' => 2,
    '#required' => TRUE,
  ];

  $form[AuthorizationCodeConfig::FLOOD_WINDOW_CONFIG_NAME] = [
    '#type' => 'textfield',
    '#title' => t('Flood window (in seconds)'),
    '#default_value' => AuthorizationCodeConfig::getFloodWindow(),
    '#size' => 4,
    '#maxlength' => 4,
    '#required' => TRUE,
  ];

  $form[AuthorizationCodeConfig::DAILY_CODE_LIMIT_CONFIG_NAME] = [
    '#type' => 'textfield',
    '#title' => t('Daily code limit (set to 0 to disable)'),
    '#default_value' => AuthorizationCodeConfig::getDailyCodeLimit(),
    '#size' => 2,
    '#maxlength' => 2,
    '#required' => TRUE,
  ];

  $form[AuthorizationCodeConfig::MAX_FETCH_COUNT_CONFIG_NAME] = [
    '#type' => 'textfield',
    '#title' => t('Max fetch count (set to 0 to disable)'),
    '#description' => t('The maximum fetch count for a single code.<br><b>Must be enabled in production</b>'),
    '#default_value' => AuthorizationCodeConfig::getMaxFetchCount(),
    '#size' => 2,
    '#maxlength' => 2,
    '#required' => TRUE,
  ];

  $form[AuthorizationCodeConfig::EXPIRATION_TIME_CONFIG_NAME] = [
    '#type' => 'textfield',
    '#title' => t('Code expiration time (in seconds)'),
    '#default_value' => AuthorizationCodeConfig::getExpirationTime(),
    '#size' => 5,
    '#maxlength' => 5,
    '#required' => TRUE,
  ];

  $form[AuthorizationCodeConfig::DEBUG_MODE_ENABLED_CONFIG_NAME] = [
    '#type' => 'checkbox',
    '#title' => t('Debug mode enabled'),
    '#default_value' => AuthorizationCodeConfig::isDebugModeEnabled(),
  ];

  return system_settings_form($form);
}
