<?php

/**
 * @file
 * API documentation for authorization code module.
 */

/**
 * @return array
 *   Associative array of authorization methods.
 *   Each item in the array must be an associative array with the following keys
 *   - send_callback: the callback function to be used for sending the
 *     authorization code.
 *   - validate_argument_callback: The callback function to use for validating
 *     the argument being used by the send_callback.
 *   - load_user_callback: The callback function to use for loading the user
 *     associated with the received argument.
 */
function hook_authorization_code_method_info() {

  $methods['email'] = array(
    'send_callback' => 'send_email_callback',
    'validate_argument_callback' => 'verify_email_callback',
    'load_user_callback' => 'load_user_callback',
  );

  return $methods;
}

/**
 * Implementation of hook_authorization_code_response_alter().
 *
 * @param $response
 */
function hook_authorization_code_response_alter(&$response) {
  global $user;

  // Check the response for a specific response and act according to that
  if (!empty($response['response']) && $response['response'] == 'user_logged_in') {
    // Replace the response with a user object
    $response = $user;
  }
}

/**
 * Implements hook_authorization_code_exception_alter().
 * @param Object $error
 *   The error.
 * @param string $process
 *   The process.
 * @param string $message
 *   The message to the user.
 */
function hook_authorization_code_exception_alter($error, $process, &$message) {
  // Replace the generic message with custom message
  if (!empty($error->getMessage()) && $error->getMessage() == 'Provided authorization argument is invalid') {
    $message = t('Please enter phone number with 10 digits or valid mail address');
  }
}
