<?php

namespace Drupal\authorization_code\Exception;

/**
 * Class DailyCodeLimitException
 * @package Drupal\authorization_code\Exception
 */
class DailyCodeLimitException extends \Exception implements SafeMessageInterface {

  const CODE = 8;

  /**
   * DailyCodeLimitException constructor.
   * @param string $message
   * @param \Exception|null $previous
   */
  public function __construct($message = 'You reached the maximum number of tries. Please try again later.', \Exception $previous = NULL) {
    parent::__construct($message, static::CODE, $previous);
  }

}
