<?php

namespace Drupal\authorization_code;

/**
 * Class AuthorizationCodeConfig
 * @todo Add the variables to our settings form
 * @package Drupal\authorization_code
 */
class AuthorizationCodeConfig {

  const DEBUG_MODE_ENABLED_CONFIG_NAME = 'authorization_code__debug_mode_enabled';
  const FLOOD_THRESHOLD_CONFIG_NAME = 'authorization_code__flood_threshold';
  const FLOOD_WINDOW_CONFIG_NAME = 'authorization_code__flood_window';
  const CODE_LENGTH_CONFIG_NAME = 'authorization_code__length';
  const EXPIRATION_TIME_CONFIG_NAME = 'authorization_code__expiration_time';
  const DAILY_CODE_LIMIT_CONFIG_NAME = 'authorization_code__daily_code_limit';
  const FLOOD_NAME_SEND_LIMIT = 'authorization_code_validate_send_limit';
  const FLOOD_NAME_AUTHORIZE_CODE = 'authorization_code_authorize_code';
  const FLOOD_NAME_SEND_CODE = 'authorization_code_send_code';
  const MAX_FETCH_COUNT_CONFIG_NAME = 'authorization_code__max_fetch_count';

  const DEFAULT_DEBUG_MODE_ENABLED = FALSE;
  const DEFAULT_MAX_FETCH_COUNT = 3;
  const DEFAULT_DAILY_CODE_LIMIT = 3;
  const DEFAULT_FLOOD_THRESHOLD = 3;
  const DEFAULT_FLOOD_WINDOW = 300;
  const DEFAULT_CODE_LENGTH = 6;
  const DEFAULT_EXPIRATION_TIME = 3600; // One hour.

  /**
   * Used to check if debug mode is enabled.
   *
   * @return bool
   *   True if debug mode enabled, false otherwise
   */
  public static function isDebugModeEnabled() {
    return variable_get(
      static::DEBUG_MODE_ENABLED_CONFIG_NAME,
      static::DEFAULT_DEBUG_MODE_ENABLED
    );
  }

  /**
   * Returns the authorization code length variable (or the default if none is
   * set).
   *
   * @return int
   *   The authorization code length.
   */
  public static function getCodeLength() {
    return variable_get(
      static::CODE_LENGTH_CONFIG_NAME,
      static::DEFAULT_CODE_LENGTH
    );
  }

  /**
   * The maximum number of codes that can be requested in a single day for a certain key.
   *
   * @return int
   *   The daily code limit.
   */
  public static function getDailyCodeLimit() {
    return variable_get(
      static::DAILY_CODE_LIMIT_CONFIG_NAME,
      static::DEFAULT_DAILY_CODE_LIMIT
    );
  }

  /**
   * The maximum number of times each user can do this event per time window.
   *
   * @return int
   *   The flood threshold.
   */
  public static function getFloodThreshold() {
    return variable_get(
      static::FLOOD_THRESHOLD_CONFIG_NAME,
      static::DEFAULT_FLOOD_THRESHOLD
    );
  }

  /**
   * Number of seconds in the time window for this event.
   *
   * @return int
   *   The flood threshold.
   */
  public static function getFloodWindow() {
    return variable_get(
      static::FLOOD_WINDOW_CONFIG_NAME,
      static::DEFAULT_FLOOD_WINDOW
    );
  }

  /**
   * Number of seconds that each authorization code will be available for.
   *
   * @return int
   *   Expiration time in seconds.
   */
  public static function getExpirationTime() {
    return variable_get(
      static::EXPIRATION_TIME_CONFIG_NAME,
      static::DEFAULT_EXPIRATION_TIME
    );
  }

  /**
   * Number of times that each authorization code can be fetched.
   *
   * @return int
   *   Maximum fetch number.
   */
  public static function getMaxFetchCount() {
    return variable_get(
      static::MAX_FETCH_COUNT_CONFIG_NAME,
      static::DEFAULT_MAX_FETCH_COUNT
    );
  }

}
