<?php

namespace Drupal\authorization_code\Exception;

/**
 * Class UpsertFailedException
 * @package Drupal\authorization_code\Exception
 */
class UpsertFailedException extends \Exception {

  const CODE = 3;

  /**
   * UpsertFailedException constructor.
   * @param string $message
   * @param \Throwable|null $previous
   */
  public function __construct(
    $message = 'Failed to write auth code to the database',
    \Exception $previous = NULL
  ) {
    $message .= ', previous message: ' . $previous->getMessage();
    parent::__construct($message, static::CODE, $previous);
  }

}
