# Authorize.Net payment Webform Integration

This module provides integration between your Drupal website and the powerful [Authorize.Net](https://www.authorize.net/) payment gateway.  
Using this module, users can make payments using a credit card via Webform.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/authorized_payment).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/authorized_payment).

## Table of contents

- [Requirements](#requirements)
- [Installation](#installation)
- [Configuration](#configuration)
- [Maintainers](#maintainers)

## Requirements

This module requires the following modules:

- [Webform](https://www.drupal.org/project/webform) module
- The Authorize.Net PHP SDK. If it's not installed by default, run:  
  `composer require authorizenet/authorizenet`
- An active account with [Authorize.Net](https://www.authorize.net/)
- (Optional) An [Authorize.Net Sandbox Account](https://developer.authorize.net/hello_world/sandbox.html) for testing

## Installation

Install as you would normally install a contributed Drupal module. For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

### To configure the module:

1. Navigate to `Home » Structure » Webform » Authorize.Net Configuration`.
2. Enter your **API Login ID** and **Transaction Key** in the Authorize.Net Configuration form.

### To enable payment settings for a specific webform:

1. Choose the webform you want to enable payments on.
2. Go to `Home » Structure » Webform » [Your Webform] » Build » Settings » Form`.
3. At the bottom of the form settings page, got to  the **"Authorization Payment Field"** 
4. You will see two checkboxes:
   - **Enable Payment Field** – This enables one-time payment.
      `Listing of one-time payments is available under: Web Services » Authorize One Time Payment List`
   - **Recurring Payment Field** – This enables recurring payments.
      `Listing of recurring payments is available under:  Web Services » Authorize Subscription Payment List`
7. Click **Save**.

### Configuring Webhooks for Recurring Payments
If you have selected the **Recurring Payment** option, follow these steps to configure webhooks in your Authorize.Net account:

1. **Log in** to your Authorize.Net account.
2. Navigate to **Account > Settings**.
3. Click on **Webhooks**, then click on **Add Endpoint**.
4. In the **Endpoint URL**, enter:  
   `https://[yourdomain]/admin/webhook`  
   _(Replace `[yourdomain]` with your actual site domain)_
5. After that events enable the following events:
   - **Subscription Events**
   - **Payment Events**
6. Click **Save**.

## Maintainers

- [Dimple (Kudosintech)](https://www.drupal.org/u/dimplel)
- [Maitri (Kudosintech)](https://www.drupal.org/u/maitri_2112)
- [Sadab (Kudosintech)](https://www.drupal.org/u/shaikh-sadab)
- [Dharmesh (Kudosintech)](https://www.drupal.org/u/dharmeshbarot89)
- [Sanket (Kudosintech)](https://www.drupal.org/u/sanketprajapati)
