<?php

namespace Drupal\webform_authorize_net_payment;

use Drupal\Core\Config\ConfigFactoryInterface;
use net\authorize\api\contract\v1\MerchantAuthenticationType;

if (!defined('AUTHORIZENET_LOG_FILE')) {
  define('AUTHORIZENET_LOG_FILE', 'phplog');
}

/**
 * Provides an Authorize.Net payment authentication service.
 */
class AuthService {

  /**
   * The admin toolbar tools configuration.
   *
   * @var \Drupal\Core\Config\Config
   */
  protected $configFactory;

  public function __construct(ConfigFactoryInterface $configFactory) {
    $this->configFactory = $configFactory;
  }

  /**
   * The merchant authentication type object.
   */
  public function getMerchantAuthentication() {
    $merchantAuthentication = new MerchantAuthenticationType();
    $merchantAuthentication->setName($this->configFactory->get('webform_authorize_net_payment.settings')->get('api_login_id'));
    $merchantAuthentication->setTransactionKey($this->configFactory->get('webform_authorize_net_payment.settings')->get('transaction_key'));
    return $merchantAuthentication;
  }

}
