<?php

namespace Drupal\webform_authorize_net_payment\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\webform_authorize_net_payment\AuthService;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

if (!defined('AUTHORIZENET_LOG_FILE')) {
  define('AUTHORIZENET_LOG_FILE', 'phplog');
}

/**
 * Controller to handle Authorize.Net webhooks.
 */
class AuthorizeNetWebformGetWebhook extends ControllerBase {
  /**
   * Handles incoming webhooks from Authorize.Net.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The incoming request object.
   *
   * @return \Symfony\Component\HttpFoundation\Response
   *   A response indicating the result of the webhook processing.
   */
  public function getWebhook(Request $request) {
    // Get the request body content.
    $requestBody = $request->getContent();

    // Decode the JSON data from the request.
    $data = json_decode($requestBody, TRUE);

    // Check if the event type is set in the received data.
    if (isset($data['eventType'])) {
      // Switch based on the event type.
      switch ($data['eventType']) {
        case 'net.authorize.payment.authcapture.created':
          // Handle the payment capture created event.
          $authService = \Drupal::service('webform_authorize_net_payment.auth_service');
          $subscription = new HandlePaymentCaptureCreatedController($authService);
          $subscription->handlePaymentCaptureCreated($data['payload']);
          break;

        case 'net.authorize.customer.subscription.cancelled':
          // Handle the subscription cancelled event.
          $subscription = new HandleSubscriptionCancelledController();
          $subscription->handleSubscriptionCancelled($data['payload']);
          break;

        case 'net.authorize.customer.subscription.expired':
          // Handle the subscription expired event.
          $subscription = new HandleSubscriptionExpireController();
          $subscription->handleSubscriptionExpire($data['payload']);
          break;

        default:
          // Handle other unrecognized event types.
          break;
      }
    }
    // Return a response indicating the webhook was received.
    return new Response('Webhook received', 200);
  }

}
