<?php

namespace Drupal\webform_authorize_net_payment\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\webform_authorize_net_payment\Service\ServiceUtil;

/**
 * Handles subscription cancellation.
 */
class HandleSubscriptionCancelledController extends ControllerBase {

  /**
   * Handles a subscription cancellation.
   *
   * @param array $payload
   *   The payload containing subscription information.
   */
  public function handleSubscriptionCancelled(array $payload) {
    $id = $payload['id'];
    $subscription = ServiceUtil::getCancelRecurringPaymentService();
    $subscription->cancelSubscription($id);
  }

}
