<?php

namespace Drupal\webform_authorize_net_payment\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\webform_authorize_net_payment\Service\ServiceUtil;

if (!defined('AUTHORIZENET_LOG_FILE')) {
  define('AUTHORIZENET_LOG_FILE', 'phplog');
}

/**
 * Controller for handling subscription expirations.
 */
class HandleSubscriptionExpireController extends ControllerBase {

  /**
   * Handles subscription expiration.
   *
   * @param array $payload
   *   The payload data.
   */
  public function handleSubscriptionExpire(array $payload) {

    $id = $payload['id'];
    $subscription = ServiceUtil::getExpireRecurringPaymentService();
    $subscription->ExpireSubscription($id);
  }

}
